package com.biz.crm.common.ie.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.service.ImportTaskService;
import com.biz.crm.common.ie.sdk.dto.CreateImportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 导入任务: ImportTask: 导入任务
 *
 * @author sunx
 * @date 2022-05-12 09:25:18
 */
@Slf4j
@Api(tags = "导入任务: ImportTask: 导入任务")
@RestController
@RequestMapping(value = {"/v1/importTask/importTask"})
public class ImportTaskController {

  @Autowired private ImportTaskService importTaskService;

  @Autowired private ImportExportProperties importExportProperties;

  /**
   * 创建导入任务
   *
   * @param dto 导入任务实体
   * @return
   */
  @ApiOperation(value = "创建导入任务")
  @PostMapping(value = "")
  public Result<ImportTask> createImportTask(@RequestBody CreateImportTaskDto dto) {
    try {
      final ImportTask importTask = new ImportTask();
      importTask.setTemplateCode(dto.getTemplateCode());
      importTask.setTaskSource(dto.getTaskSource());
      importTask.setFileCode(dto.getFileCode());
      importTask.setParametersJson(dto.getParametersJson());
      ImportTask current = this.importTaskService.create(importTask);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 查询分页列表
   *
   * @param pageable 分页
   * @param paginationDto 查询参数
   * @return
   */
  @ApiOperation(value = "查询分页列表")
  @GetMapping(value = {"/findByConditions"})
  public Result<Page<ImportTask>> findByConditions(
      @PageableDefault(50) Pageable pageable, ImportTaskPaginationDto paginationDto) {
    try {
      Page<ImportTask> result = this.importTaskService.findByConditions(pageable, paginationDto);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据导入任务编码获取详情
   *
   * @param taskCode 任务编码
   * @return
   */
  @ApiOperation(value = "根据导入任务编码获取详情")
  @GetMapping(value = {"/findDetailByTaskCode"})
  public Result<ImportTask> findDetailByTaskCode(@RequestParam("taskCode") String taskCode) {
    try {
      ImportTask importTask = this.importTaskService.findDetailByTaskCode(taskCode);
      return Result.ok(importTask);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 获取导入文件大小限制/mb
   *
   * @return
   */
  @ApiOperation(value = "获取导入文件大小限制/mb")
  @GetMapping(value = {"/findImportMaxSize"})
  public Result<Long> findImportMaxSize() {
    return Result.ok(
        this.importExportProperties.getImportProperties().getExcelMaxSize().toMegabytes());
  }
}
