package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.mapper.ImportTemplateDetailMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 导入模板明细(repository)
 *
 * @author sunx
 * @date 2022-05-10 10:57:19
 */
@Component
public class ImportTemplateDetailRepository
    extends ServiceImpl<ImportTemplateDetailMapper, ImportTemplateDetail> {

  /**
   * 根据默认业务编码获取模板明细信息
   *
   * @param businessCode 业务编码
   * @return
   */
  public List<ImportTemplateDetail> findDetailByBusinessCode(String businessCode) {
    return this.lambdaQuery()
        .eq(ImportTemplateDetail::getBusinessCode, businessCode)
        .orderByAsc(ImportTemplateDetail::getSort)
        .list();
  }

  /**
   * 根据业务编码集合删除数据
   *
   * @param businessCodes 业务编码集合
   */
  public void deleteByBusinessCodes(List<String> businessCodes) {
    LambdaQueryWrapper<ImportTemplateDetail> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.in(ImportTemplateDetail::getBusinessCode, businessCodes);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据任务模板明细编码获取明细信息
   *
   * @param templateCode 模板编码
   * @return
   */
  public ImportTemplateDetail findDetailByTemplateCode(String templateCode) {
    return this.lambdaQuery().eq(ImportTemplateDetail::getTemplateCode, templateCode).one();
  }
}
