package com.biz.crm.common.ie.local.service.init;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.ImportExportMasterKeeperTask;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.google.common.collect.Sets;
import cn.hutool.core.thread.ThreadUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入导出应用启动完成后执行
 *
 * @author sunx
 * @date 2022/5/10
 */
@Component("_-_ImportExportTaskInitProcess")
@Slf4j
@Order(1)
public class ImportExportTaskInitProcess implements CommandLineRunner {
  @Autowired
  private ImportExportProperties importExportProperties;
  @Autowired
  private ApplicationContext applicationContext;
  
  @Autowired(required = false)
  private List<ImportProcess<?>> importProcesses;
  
  @Autowired(required = false)
  private List<ExportProcess<?>> exportProcesses;
  
  @Override
  public void run(String... args) throws Exception {
    this.validateProcessRepeat();
    ImportExportMasterKeeperTask task = applicationContext.getBean(ImportExportMasterKeeperTask.class);
    if (importExportProperties.getExecTask()) {
      ThreadUtil.execAsync(task, true);
      log.info("系统配置导入导出任务--启动！！！！！！！");
    }else {
      log.warn("系统配置导入导出任务--禁用！！！！！！！");
    }
  }
  
  /** 校验导入process 业务编码不能重复 */
  private void validateProcessRepeat() {
    StringBuilder sb = new StringBuilder();
    // 导入模板整理
    if (CollectionUtils.isNotEmpty(importProcesses)) {
      Set<String> importCodeSet = Sets.newHashSet();
      Set<String> repeatImportCodeSet = importProcesses.stream()
          .filter(a -> !importCodeSet.add(a.getTemplateCode()))
          .map(ImportProcess::getTemplateCode)
          .collect(Collectors.toSet());
      if (CollectionUtils.isNotEmpty(repeatImportCodeSet)) {
        sb.append("导入模板编码")
            .append(String.join(",", repeatImportCodeSet))
            .append("存在重复");
      }
    }
    // 导出模板整理
    if (CollectionUtils.isNotEmpty(exportProcesses)) {
      Set<String> exportCodeSet = Sets.newHashSet();
      Set<String> repeatExportCodeSet = exportProcesses.stream()
          .filter(a -> !exportCodeSet.add(a.getBusinessCode()))
          .map(ExportProcess::getBusinessCode)
          .collect(Collectors.toSet());
      if (CollectionUtils.isNotEmpty(repeatExportCodeSet)) {
        sb.append("导出模板编码")
            .append(String.join(",", repeatExportCodeSet))
            .append("存在重复");
      }
    }

    Validate.isTrue(sb.length() == 0, sb.toString());
  }
}
