package com.biz.crm.common.ie.local.service.internal;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import com.biz.crm.common.ie.local.service.ImportExportTaskPoolService;
import com.biz.crm.common.ie.local.service.task.ImportExportThreadPoolExecutor;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForExport;
import com.biz.crm.common.ie.local.service.task.IeTaskExecutorForImport;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForImport;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入导出线程池接口实现
 *
 * @author sunx
 * @date 2022/6/23
 */
@Slf4j
@Service
public class ImportExportTaskPoolServiceImpl implements ImportExportTaskPoolService {
  
  @Autowired
  private ApplicationContext applicationContext;
  
  @Autowired
  @Qualifier("_importExportThreadPoolExecutor")
  private ImportExportThreadPoolExecutor importExportThreadPoolExecutor;
  
  @Override
  public void reloadTask(String poolName, String taskCode, String ieType, String applicationName) {
    ThreadPoolExecutor executor = null;
    Runnable run = null;
    // 设置变量
    if (TypeEnum.IMPORT.getDictCode().equals(ieType)) {
      IeExecutorVoForImport vo = new IeExecutorVoForImport();
      vo.setTaskCode(taskCode);
      vo.setApplicationName(applicationName);
      run      = this.applicationContext.getBean(IeTaskExecutorForImport.class, vo);
      executor = this.importExportThreadPoolExecutor.findImportThreadPoolExecutorByKey(poolName);
    } else if (TypeEnum.EXPORT.getDictCode().equals(ieType)) {
      IeExecutorVoForExport vo = new IeExecutorVoForExport();
      vo.setTaskCode(taskCode);
      vo.setApplicationName(applicationName);
      // 设置导出任务编码
      vo.setExportTaskDetailCode(taskCode);
      run      = this.applicationContext.getBean(IeTaskExecutorForExport.class, vo);
      executor = this.importExportThreadPoolExecutor.findExportThreadPoolExecutorByKey(poolName);
    } else {
      log.warn("请检查代码：系统发现不明类型动作！！！ieType={}", ieType);
    }
    // 查看是否有执行器，没有执行器直接结束
    if (executor == null) {
      return;
    }
    // 开始执行
    executor.submit(run);
  }
  
  @Override
  public Map<String, Object> findDashboard(String name, String ieType) {
    if (TypeEnum.IMPORT.getDictCode().equals(ieType)) {
      return this.findPoolDashboard(
          this.importExportThreadPoolExecutor.findImportThreadPoolExecutorByKey(name));
    } else if (TypeEnum.EXPORT.getDictCode().equals(ieType)) {
      return this.findPoolDashboard(
          this.importExportThreadPoolExecutor.findExportThreadPoolExecutorByKey(name));
    }
    return Maps.newHashMap();
  }
  
  @Override
  public Map<String, Set<String>> findPoolNames() {
    final Map<String, ThreadPoolExecutor> map0 = this.importExportThreadPoolExecutor.getImportThreadPoolExecutorMap();
    final Map<String, ThreadPoolExecutor> map1 = this.importExportThreadPoolExecutor.getExportThreadPoolExecutorMap();
    Map<String, Set<String>> re = Maps.newHashMap();
    if (!map0.isEmpty()) {
      re.put("导入线程池", map0.keySet());
    }
    if (!map1.isEmpty()) {
      re.put("导出线程池", map1.keySet());
    }
    return re;
  }
  
  /**
   * 获取线程池看板信息
   *
   * @param executor
   * @return
   */
  private Map<String, Object> findPoolDashboard(ThreadPoolExecutor executor) {
    Map<String, Object> map = Maps.newLinkedHashMap();
    map.put("核心线程数", executor.getCorePoolSize());
    map.put("最大线程数", executor.getMaximumPoolSize());
    map.put("执行中任务数量", executor.getActiveCount());
    map.put("待执行任务数量", executor.getQueue().size());
    map.put("已完成任务数量", executor.getCompletedTaskCount());
    map.put("总任务数量", executor.getTaskCount());
    return map;
  }
}
