package com.biz.crm.common.ie.local.service.spring.rest;
/**
 * @title IRequestParamParse
 * @date 2023/10/9 14:03
 * @author Kevin
 * @description 基本数据类型参数转换通用接口
 */
public interface IRequestParamParse <T> {

  /**
   * 当前策略是否可以使用
   * @param parameterType
   * @return
   */
  public boolean isApplicable(Class<?> parameterType);

  /**
   * 根据传入的value，如果value为空，则将defaultValueString转换为T类型的对象返回，如果转换失败，则抛出异常
   * @param defaultValueString
   * @return
   * @throws IllegalArgumentException
   */
  public T  getValue(String defaultValueString) throws IllegalArgumentException;

}
