package com.biz.crm.common.ie.local.service.task.tools;

import com.biz.crm.business.common.sdk.constant.CommonConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入导出统一要执行的方法，重建用户权限
 * 
 * @author Ken
 * @version 1.0 Copyright 2022年12月5日 下午3:44:32
 */
@Slf4j
public class TaskExecutorAuthTool {
  /**
   * 重建用户权限
   * 
   * @param loginUserService 登录用户服务
   * @param vo 导入导出对象
   */
  public static void refreshUseAuthAndTenantCode(LoginUserService loginUserService, IeExecutorVo vo,
      Integer userDefaultLoginType) {
    String taskTenantCode = vo.getTenantCode();
    String account = vo.getAccount();
    // * 1、重建临时securityContext，为后续远程调用做准备
    // =============
    Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
    FacturerUserDetails facturer = null;
//    if (authentication != null) {
//      Object details = authentication.getDetails();
//      if (details instanceof FacturerUserDetails) {
//        facturer = (FacturerUserDetails) details;
//        if (facturer.getAccount().equals(account) && facturer.getTenantCode().equals(taskTenantCode)) {
//          // 信息一致，直接返回
//          return;
//        }
//      }
//    }
    if (facturer == null) {
      // 重新塑造厂商用户信息
      // 重新刷新角色信息
      List<SimpleGrantedAuthority> authorities = new ArrayList<>();
      facturer = new FacturerUserDetails();
      facturer.setAccount(account);
      facturer.setTenantCode(taskTenantCode);
      facturer.setIdentityType("u");
      facturer.setLoginType(userDefaultLoginType);
      facturer.setRoleCodes(new String[]{CommonConstant.DEFAULT_ROLE_ADMIN});

      UsernamePasswordAuthenticationToken autoObj =
          new UsernamePasswordAuthenticationToken(account, "xzk-001", authorities);
      autoObj.setDetails(facturer);
      SecurityContextHolder.getContext().setAuthentication(autoObj);
    }
    // 设定成当前线程的鉴权信息，但由于当前线程不再web容器中，所以没有sessionId信息
  
    // * 2、开始远程调用，获取loginUserService.refreshAuthentication对象。
    log.debug("* 重建用户权限 *");
    TaskGlobalParamsVo paramsVo = new TaskGlobalParamsVo();
    String appCode = vo.getAppCode();
    // appCode = "crm3to1";
    paramsVo.setAppCode(appCode);
    // taskTenantCode = "crm3to1";
    paramsVo.setTenantCode(taskTenantCode);
    paramsVo.setCreateAccount(vo.getAccount());
    paramsVo.setCreateAccountName(vo.getAccountName());
    // TaskCode再后续刷新用户
    paramsVo.setTaskCode(vo.getTaskCode());
    paramsVo.setApplicationName(vo.getApplicationName());
    // 刷新用户权限
    Authentication refreshAuthentication = loginUserService.refreshAuthentication(paramsVo);
//    FacturerUserDetails details = (FacturerUserDetails) refreshAuthentication.getDetails();
    
    String tenantCode = TenantUtils.getTenantCode();
    Validate.isTrue(true == StringUtils.equals(taskTenantCode, tenantCode), "租户TenantCode刷新失败=%s", taskTenantCode);
  }

}
