/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.context.ExportTaskContext;
import com.biz.crm.common.ie.local.context.ExportTaskContextHolder;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.model.dto.ExportTaskDetailModelDto;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskDetailRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import com.biz.crm.common.ie.sdk.dto.ExportTaskQueueDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.enums.LoadStatusEnum;
import com.biz.crm.common.ie.sdk.event.ImportExportTaskEventListener;
import com.biz.crm.common.ie.sdk.excel.process.AbstractEsParagraphExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.utils.IeJsonUtils;
import com.biz.crm.common.ie.sdk.vo.EsParagraphFieldRangeVo;
import com.biz.crm.common.ie.sdk.vo.ExportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.bizunited.nebula.common.register.ElasticsearchQueryRegister;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="exportTaskDetailService")
public class ExportTaskDetailServiceImpl
implements ExportTaskDetailService {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskDetailServiceImpl.class);
    @Autowired(required=false)
    private ExportTaskDetailRepository exportTaskDetailRepository;
    @Autowired(required=false)
    private ExportProcessService exportProcessService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ExportTaskRepository exportTaskRepository;
    @Autowired(required=false)
    private ExportSendProcessMsgBean exportSendProcessMsgBean;
    @Autowired(required=false)
    private List<ImportExportTaskEventListener> importExportTaskAuthRecordListeners;
    @Autowired(required=false)
    private ElasticsearchQueryService elasticsearchQueryService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public List<ExportTaskDetail> findByTaskCodes(Set<String> taskCodeSet) {
        if (CollectionUtils.isEmpty(taskCodeSet)) {
            return Lists.newLinkedList();
        }
        return this.exportTaskDetailRepository.findByTaskCodes(taskCodeSet);
    }

    @Override
    @Transactional
    public void create(List<ExportTaskDetail> list, String taskCode) {
        Validate.notBlank((CharSequence)taskCode, (String)"\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.exportTaskDetailRepository.deleteByTaskCode(taskCode);
        for (ExportTaskDetail item : list) {
            item.setId(null);
            item.setTaskCode(taskCode);
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setExecStatus(ExecStatusEnum.DEFAULT.getDictCode());
            item.setLoadStatus(LoadStatusEnum.NO.getDictCode());
        }
        this.exportTaskDetailRepository.saveBatch(list);
    }

    @Override
    public List<ExportTaskDetail> findByExportTaskDetailModelDto(ExportTaskDetailModelDto dto) {
        if (Objects.isNull(dto)) {
            return Lists.newLinkedList();
        }
        return this.exportTaskDetailRepository.findByExportTaskDetailModelDto(dto);
    }

    @Override
    @Transactional
    public void updateLocalStatus(Set<String> detailCodeSet, String loadStatus) {
        Validate.isTrue((!CollectionUtils.isEmpty(detailCodeSet) ? 1 : 0) != 0, (String)"\u5bfc\u51fa\u5b50\u4efb\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((CharSequence)loadStatus, (String)"\u52a0\u8f7d\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.exportTaskDetailRepository.updateLocalStatus(detailCodeSet, loadStatus);
    }

    @Override
    public ExportTaskDetail findByDetailCode(String detailCode) {
        if (StringUtils.isBlank((CharSequence)detailCode)) {
            return null;
        }
        ExportTaskDetail detail = this.exportTaskDetailRepository.findByDetailCode(detailCode);
        OrdinaryFileVo fileVo = this.fileHandleService.findById(detail.getFileCode());
        if (fileVo == null) {
            return detail;
        }
        FileModelVo fileModelVo = new FileModelVo();
        fileModelVo.setFileCode(fileVo.getId());
        fileModelVo.setFileName(fileVo.getOriginalFileName());
        detail.setFile(fileModelVo);
        return detail;
    }

    @Override
    public ExportTaskDetail findDetailByDetailCode(String detailCode) {
        if (StringUtils.isBlank((CharSequence)detailCode)) {
            return null;
        }
        ExportTaskDetail detail = this.findByDetailCode(detailCode);
        if (Objects.isNull((Object)detail)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)detail.getFileCode())) {
            return detail;
        }
        OrdinaryFileVo fileVo = this.fileHandleService.findById(detail.getFileCode());
        if (fileVo == null) {
            return detail;
        }
        FileModelVo fileModelVo = new FileModelVo();
        fileModelVo.setFileCode(fileVo.getId());
        fileModelVo.setFileName(fileVo.getOriginalFileName());
        detail.setFile(fileModelVo);
        return detail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public List<ExportTaskDetail> saveExportTaskAndCreateExportTaskDetail(ExportTask exportTask) {
        Integer total;
        String businessCode = exportTask.getBusinessCode();
        String taskCode = exportTask.getTaskCode();
        ExportProcess exportProcess = this.exportProcessService.findExportProcess(businessCode);
        Map<String, Object> params = this.buildExportParamMap(exportTask, exportProcess);
        try {
            ExportTaskContext taskContext = new ExportTaskContext();
            taskContext.setTaskParamsMap(params);
            ExportTaskProcessVo taskProcessVo = (ExportTaskProcessVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)exportTask, ExportTaskProcessVo.class, HashSet.class, ArrayList.class, new String[0]);
            taskContext.setTaskProcessVo(taskProcessVo);
            ExportTaskContextHolder.setContext(taskContext);
            total = exportProcess.getTotal(params);
        }
        finally {
            ExportTaskContextHolder.clearContext();
        }
        exportTask.setTotal(total);
        List<ExportTaskDetail> list = this.exportExcel(exportProcess, exportTask);
        if (exportProcess instanceof AbstractEsParagraphExportProcess) {
            exportTask.setExecStatus(ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode());
            list.forEach(taskDetail -> taskDetail.setExecStatus(ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode()));
        }
        this.exportTaskRepository.saveOrUpdate((Object)exportTask);
        this.exportTaskDetailRepository.deleteByTaskCode(taskCode);
        for (ExportTaskDetail item : list) {
            item.setId(null);
            item.setTaskCode(taskCode);
            item.setTenantCode(TenantUtils.getTenantCode());
            item.setExecStatus(StringUtils.isNotBlank((CharSequence)item.getExecStatus()) ? item.getExecStatus() : ExecStatusEnum.DEFAULT.getDictCode());
            item.setLoadStatus(LoadStatusEnum.NO.getDictCode());
        }
        this.exportTaskDetailRepository.saveBatch(list);
        if (!CollectionUtils.isEmpty(this.importExportTaskAuthRecordListeners)) {
            for (ImportExportTaskEventListener listener : this.importExportTaskAuthRecordListeners) {
                listener.onTaskCreate(true, exportTask.getTaskCode(), exportTask.getAppCode(), exportTask.getTenantCode(), exportTask.getApplicationName(), exportTask.getCreateAccount());
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> buildExportParamMap(ExportTask exportTask, ExportProcess<?> exportProcess) {
        String parametersJson = exportTask.getParametersJson();
        Map<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)parametersJson)) {
            HashMap paramMap = IeJsonUtils.fromJson((String)parametersJson, HashMap.class);
            params = this.findParams(exportProcess, paramMap);
        }
        params.put("webApiUrl", exportTask.getWebApiUrl());
        return params;
    }

    @Override
    @Transactional
    public List<EsParagraphFieldRangeVo> execExportTaskDetailEsParagraph(ExportTask exportTask, ExportTaskDetail exportTaskDetail, List<EsParagraphFieldRangeVo> lastFieldRanges) {
        int detailTotal;
        AbstractEsParagraphExportProcess exportProcess = (AbstractEsParagraphExportProcess)this.exportProcessService.findExportProcess(exportTask.getBusinessCode());
        Class registerClass = exportProcess.getElasticsearchQueryRegister();
        ElasticsearchQueryRegister queryRegister = this.elasticsearchQueryService.findRegisterByClass(registerClass);
        Validate.notNull((Object)queryRegister, (String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684ES\u67e5\u8be2\u6ce8\u518c\u5668\u5b9e\u73b0", (Object[])new Object[0]);
        Map<String, Object> params = this.buildExportParamMap(exportTask, (ExportProcess<?>)exportProcess);
        SearchSourceBuilder sourceBuilder = queryRegister.buildSearch(params);
        List<Pair<String, SortOrder>> sortOrderList = this.buildEsIndexSort(queryRegister, sourceBuilder);
        sourceBuilder.sorts().clear();
        sortOrderList.forEach(orderPair -> sourceBuilder.sort((String)orderPair.getLeft(), (SortOrder)orderPair.getRight()));
        int queryPageSize = exportProcess.getQueryPageSize();
        ArrayList fieldRanges = Lists.newArrayList();
        long startTime = System.currentTimeMillis();
        log.debug("******\u5b50\u4efb\u52a1[{}]\u5f00\u59cb\u8fdb\u884cES\u6570\u636e\u5206\u6bb5,\u603b\u6570\u636e\u91cf[{}],\u67e5\u8be2\u5206\u9875\u5927\u5c0f[{}]*********", new Object[]{exportTaskDetail.getDetailCode(), detailTotal, queryPageSize});
        for (detailTotal = exportTaskDetail.getPageSize().intValue(); detailTotal > 0; detailTotal -= queryPageSize) {
            queryPageSize = Math.min(queryPageSize, detailTotal);
            if (!CollectionUtils.isEmpty(lastFieldRanges)) {
                sourceBuilder.searchAfter(lastFieldRanges.stream().map(EsParagraphFieldRangeVo::getEnd).toArray());
            }
            sourceBuilder.from(0).size(queryPageSize);
            SearchResponse searchResponse = this.elasticsearchQueryService.queryWithRequest(new SearchRequest(new String[]{queryRegister.getIndexName()}).source(sourceBuilder));
            List mapList = this.elasticsearchQueryService.convertResponse(searchResponse, Map.class);
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)mapList) ? 1 : 0) != 0, (String)"ES\u67e5\u8be2\u6570\u636e\u5339\u914d\u51fa\u9519", (Object[])new Object[0]);
            lastFieldRanges.clear();
            for (Pair<String, SortOrder> orderPair2 : sortOrderList) {
                EsParagraphFieldRangeVo fieldRange = new EsParagraphFieldRangeVo();
                fieldRange.setFieldName((String)orderPair2.getLeft());
                fieldRange.setSort(((SortOrder)orderPair2.getRight()).toString());
                fieldRange.setStart(((Map)mapList.get(0)).get(fieldRange.getFieldName()));
                fieldRange.setEnd(((Map)mapList.get(mapList.size() - 1)).get(fieldRange.getFieldName()));
                lastFieldRanges.add(fieldRange);
            }
            ArrayList currentRanges = Lists.newArrayList();
            sortOrderList.forEach(orderPair -> {
                EsParagraphFieldRangeVo fieldRange = new EsParagraphFieldRangeVo();
                fieldRange.setFieldName((String)orderPair.getLeft());
                fieldRange.setSort(((SortOrder)orderPair.getRight()).toString());
                mapList.sort((o1, o2) -> {
                    Object object1 = o1.get(fieldRange.getFieldName());
                    Object object2 = o2.get(fieldRange.getFieldName());
                    if (Objects.isNull(object1) && Objects.isNull(object2)) {
                        return 0;
                    }
                    if (Objects.isNull(object1)) {
                        return -1;
                    }
                    if (Objects.isNull(object2)) {
                        return 1;
                    }
                    Validate.isTrue((object1 instanceof Comparable && object2 instanceof Comparable ? 1 : 0) != 0, (String)"\u6392\u5e8f\u5b57\u6bb5\u5bf9\u5e94java\u7c7b\u578b\u65e0\u6cd5\u6bd4\u8f83\u5927\u5c0f", (Object[])new Object[0]);
                    return ((Comparable)object1).compareTo(object2);
                });
                fieldRange.setStart(((Map)mapList.get(0)).get(fieldRange.getFieldName()));
                fieldRange.setEnd(((Map)mapList.get(mapList.size() - 1)).get(fieldRange.getFieldName()));
                currentRanges.add(fieldRange);
            });
            fieldRanges.add(currentRanges);
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)fieldRanges) ? 1 : 0) != 0, (String)"ES\u5206\u6bb5\u6570\u636e\u51fa\u9519", (Object[])new Object[0]);
        ExportTaskDetail updateTaskDetail = new ExportTaskDetail();
        updateTaskDetail.setId(exportTaskDetail.getId());
        updateTaskDetail.setParagraphRanges(JSONArray.toJSONString((Object)fieldRanges));
        updateTaskDetail.setExecStatus(ExecStatusEnum.DEFAULT.getDictCode());
        log.debug("******\u5b50\u4efb\u52a1[{}]\u7ed3\u675f\u8fdb\u884cES\u6570\u636e\u5206\u6bb5,\u603b\u8017\u65f6[{}]*********", (Object)exportTaskDetail.getDetailCode(), (Object)(System.currentTimeMillis() - startTime));
        this.exportTaskDetailRepository.updateById((Object)updateTaskDetail);
        return lastFieldRanges;
    }

    private List<Pair<String, SortOrder>> buildEsIndexSort(ElasticsearchQueryRegister queryRegister, SearchSourceBuilder sourceBuilder) {
        ArrayList resultList = Lists.newArrayList();
        GetSettingsRequest settingsRequest = new GetSettingsRequest().indices(new String[]{queryRegister.getIndexName()});
        GetSettingsResponse settingsResponse = this.elasticsearchQueryService.queryWithSetting(settingsRequest);
        List sorts = sourceBuilder.sorts();
        if (!CollectionUtils.isEmpty((Collection)sorts)) {
            for (SortBuilder sortBuilder : sorts) {
                FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)sortBuilder;
                if (Objects.isNull(fieldSortBuilder) || StringUtils.isBlank((CharSequence)fieldSortBuilder.getFieldName()) || Objects.isNull(fieldSortBuilder.order())) continue;
                resultList.add(Pair.of((Object)fieldSortBuilder.getFieldName(), (Object)fieldSortBuilder.order()));
            }
        }
        List filedNames = resultList.stream().map(Pair::getLeft).collect(Collectors.toList());
        Settings settings = (Settings)settingsResponse.getIndexToSettings().get((Object)queryRegister.getIndexName());
        if (Objects.nonNull(settings)) {
            String settingsStr = settings.toString();
            JSONObject indexSortJson = JSON.parseObject((String)settingsStr);
            JSONArray fieldArray = indexSortJson.getJSONArray("index.sort.field");
            JSONArray orderArray = indexSortJson.getJSONArray("index.sort.order");
            if (!CollectionUtils.isEmpty((Collection)fieldArray) && !CollectionUtils.isEmpty((Collection)orderArray) && fieldArray.size() == orderArray.size()) {
                for (Object filedObject : fieldArray) {
                    if (filedNames.contains(filedObject.toString())) continue;
                    Object orderObject = orderArray.get(fieldArray.indexOf(filedObject));
                    resultList.add(Pair.of((Object)filedObject.toString(), (Object)SortOrder.fromString((String)orderObject.toString())));
                }
            }
        }
        if (!filedNames.contains("id")) {
            resultList.add(Pair.of((Object)"id", (Object)SortOrder.DESC));
        }
        log.info("\u83b7\u53d6ES\u5206\u6bb5\u6392\u5e8f\u5b57\u6bb5\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)resultList));
        return resultList;
    }

    private List<ExportTaskDetail> exportExcel(ExportProcess<?> exportProcess, ExportTask exportTask) {
        Validate.isTrue((exportTask.getTotal().compareTo(0) > 0 ? 1 : 0) != 0, (String)"\u672a\u67e5\u5230\u5339\u914d\u6570\u636e\u65e0\u9700\u6267\u884c\u5bfc\u51fa", (Object[])new Object[0]);
        Integer pageSize = exportProcess.getPageSize();
        Integer total = exportTask.getTotal();
        List<ExportTaskDetail> list = this.findDetail(exportTask, total, pageSize);
        ExportProcessMsgVo msgVo = new ExportProcessMsgVo();
        msgVo.setTaskCode(exportTask.getTaskCode());
        msgVo.setMainFlag(Boolean.valueOf(true));
        msgVo.setExecStatus(ExecStatusEnum.DEFAULT.getDictCode());
        msgVo.setProcessType(ExportProcessEnum.START.getCode());
        msgVo.setRemark(ExportProcessEnum.WAIT.getFormat());
        msgVo.setAccount(exportTask.getCreateAccount());
        msgVo.setFileName(exportTask.getFileName());
        this.exportSendProcessMsgBean.sendMsgByAll(msgVo);
        ExportTaskQueueDto exportTaskQueueDto = new ExportTaskQueueDto();
        exportTaskQueueDto.setTaskCode(exportTask.getTaskCode());
        exportTaskQueueDto.setAccount(exportTask.getCreateAccount());
        exportTaskQueueDto.setMainFlag(true);
        exportTaskQueueDto.setTotalSize(total);
        this.exportSendProcessMsgBean.sendTaskProcessQueueMsg(exportTaskQueueDto, 0);
        return list;
    }

    private List<ExportTaskDetail> findDetail(ExportTask exportTask, Integer total, Integer pageSize) {
        Validate.isTrue((pageSize.compareTo(0) > 0 ? 1 : 0) != 0, (String)"\u5904\u7406\u5668\u5b50\u4efb\u52a1\u62c6\u5206size\u9700\u5927\u4e8e0", (Object[])new Object[0]);
        ArrayList list = Lists.newArrayList();
        Integer page = total % pageSize == 0 ? total / pageSize - 1 : total / pageSize;
        Integer lastPageSize = total % pageSize == 0 ? pageSize : total % pageSize;
        for (int i = 0; i <= page; ++i) {
            ExportTaskDetail cur = new ExportTaskDetail();
            cur.setPageSize(i == page ? lastPageSize : pageSize);
            cur.setPageNo(i);
            cur.setTaskCode(exportTask.getTaskCode());
            cur.setAppCode(exportTask.getAppCode());
            cur.setApplicationName(exportTask.getApplicationName());
            cur.setDetailCode(exportTask.getTaskCode() + "_" + cur.getPageNo());
            cur.setMarsListCode(exportTask.getMarsListCode());
            list.add(cur);
        }
        return list;
    }

    private Map<String, Object> findParams(ExportProcess<?> exportProcess, Map<String, Object> paramMap) {
        if (Objects.isNull(exportProcess)) {
            return Maps.newHashMap();
        }
        Map map = exportProcess.getGlobalParams();
        if (map == null) {
            map = Maps.newHashMap();
        }
        map.putAll(paramMap);
        return map;
    }
}

