/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IMethodParameterTypeParse;
import com.biz.crm.common.ie.sdk.dto.data.domain.PageRequestBo;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.stereotype.Component;

@Component
public class MethodParameterTypeParsePageable
implements IMethodParameterTypeParse<Pageable> {
    private static final Logger log = LoggerFactory.getLogger(MethodParameterTypeParsePageable.class);

    @Override
    public boolean supportsParameter(MethodParameter methodParameter) {
        Class parameterType = methodParameter.getParameterType();
        return parameterType == Pageable.class;
    }

    @Override
    public Pageable resolveArgument(MethodParameter methodParameter, Map<String, Object> requestParamMap) throws IllegalArgumentException {
        Object o;
        String parameterName = methodParameter.getParameterName();
        if (StringUtils.isNotBlank((CharSequence)parameterName) && (o = requestParamMap.get(parameterName)) instanceof Pageable) {
            return (Pageable)o;
        }
        PageRequestBo defaultPageable = null;
        PageableDefault parameterAnnotation = (PageableDefault)methodParameter.getParameterAnnotation(PageableDefault.class);
        if (parameterAnnotation != null) {
            Sort sort;
            String[] sortString = parameterAnnotation.sort();
            if (sortString.length == 0) {
                sort = Sort.unsorted();
            } else {
                Sort.Direction direction = parameterAnnotation.direction();
                sort = Sort.by((Sort.Direction)direction, (String[])sortString);
            }
            int page = parameterAnnotation.page();
            int size = parameterAnnotation.size();
            int value = parameterAnnotation.value();
            if (value != 10 && size == 10) {
                size = value;
            }
            defaultPageable = new PageRequestBo(page, size, sort);
        }
        Pageable pageable = this.getPageable(requestParamMap, (Pageable)defaultPageable);
        return pageable;
    }

    private Pageable getPageable(Map<String, Object> requestParamMap, Pageable defaultPageable) {
        Object varPage = requestParamMap.get("page");
        int page = NumberUtils.toInt(varPage == null ? null : "" + varPage, (int)defaultPageable.getPageNumber());
        Object varSize = requestParamMap.get("size");
        int size = NumberUtils.toInt(varSize == null ? null : "" + varSize, (int)defaultPageable.getPageSize());
        Sort sort = null;
        try {
            Object varSort = requestParamMap.get("sort");
            if (varSort != null) {
                String sortParam = "" + varSort;
                String[] sortSplit = sortParam.split(",");
                switch (sortSplit.length) {
                    case 1: {
                        sort = Sort.by((String[])new String[]{sortParam});
                        break;
                    }
                    case 2: {
                        Sort.Direction direction = Sort.Direction.fromString((String)sortSplit[1]);
                        sort = Sort.by((Sort.Direction)direction, (String[])new String[]{sortSplit[0]});
                        break;
                    }
                    default: {
                        sort = defaultPageable.getSort();
                    }
                }
            }
        }
        catch (Exception e) {
            sort = defaultPageable.getSort();
        }
        return this.getPageable(page, size, sort);
    }

    private Pageable getPageable(int page, int pageSize, Sort sort) {
        if (sort == null) {
            sort = Sort.unsorted();
        }
        PageRequestBo pageRequestBo = new PageRequestBo(page, pageSize, sort);
        return pageRequestBo;
    }
}

