package com.biz.crm.common.ie.local.config;

import com.biz.crm.common.ie.local.service.strategy.DefaultExcelProcessStrategyImpl;
import com.biz.crm.common.ie.local.service.task.ImportExportThreadPoolExecutor;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 导入导出config
 *
 * @author sunx
 * @date 2022/5/10
 */
@Configuration
@EntityScan(basePackages = "com.biz.crm.common.ie.local.entity")
@EnableConfigurationProperties(ImportExportProperties.class)
public class ImportExportConfig {

  private final ImportExportProperties importExportProperties;

  public ImportExportConfig(ImportExportProperties importExportProperties) {
    this.importExportProperties = importExportProperties;
  }

  @Bean("_importExportThreadPoolExecutor")
  public ImportExportThreadPoolExecutor ieThreadPoolExecutor() {
    ImportExportThreadPoolExecutor importExportThreadPoolExecutor = new ImportExportThreadPoolExecutor();
    importExportThreadPoolExecutor.setImportTaskCount(this.importExportProperties.getImportProperties().getTaskCount());
    importExportThreadPoolExecutor.setImportWorkQueueCount(this.importExportProperties.getImportProperties().getWorkQueueCount());
    importExportThreadPoolExecutor.setExportTaskCount(this.importExportProperties.getExportProperties().getTaskCount());
    importExportThreadPoolExecutor.setLargeExportTaskCount(this.importExportProperties.getExportProperties().getLargeTaskCount());
    importExportThreadPoolExecutor.setLargeExportWorkQueueCount(this.importExportProperties.getExportProperties().getLargeWorkQueueCount());
    importExportThreadPoolExecutor.setLargeExportTaskDataNum(this.importExportProperties.getExportProperties().getLargeTaskDataNum());
    importExportThreadPoolExecutor.setMediumExportTaskCount(this.importExportProperties.getExportProperties().getMediumTaskCount());
    importExportThreadPoolExecutor.setMediumExportWorkQueueCount(this.importExportProperties.getExportProperties().getMediumWorkQueueCount());
    importExportThreadPoolExecutor.setMediumExportTaskDataNum(this.importExportProperties.getExportProperties().getMediumTaskDataNum());
    importExportThreadPoolExecutor.setSmallExportTaskCount(this.importExportProperties.getExportProperties().getSmallTaskCount());
    importExportThreadPoolExecutor.setSmallExportWorkQueueCount(this.importExportProperties.getExportProperties().getSmallWorkQueueCount());
    importExportThreadPoolExecutor.setExportGetTotalTaskCount(this.importExportProperties.getExportAsyncGetDataProperties().getTaskCount());
    importExportThreadPoolExecutor.setExportGetTotalWorkQueueCount(this.importExportProperties.getExportAsyncGetDataProperties().getWorkQueueCount());
    importExportThreadPoolExecutor.setExportEsParagraphTaskCount(this.importExportProperties.getExportEsParagraphProperties().getTaskCount());
    importExportThreadPoolExecutor.setExportEsParagraphWorkQueueCount(this.importExportProperties.getExportEsParagraphProperties().getWorkQueueCount());
    return importExportThreadPoolExecutor;
  }

  @Bean
  public CrmExcelProcessStrategy crmExcelProcessStrategy() {
    return new DefaultExcelProcessStrategyImpl();
  }
}
