package com.biz.crm.common.ie.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.model.dto.ImportTaskModelDto;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 导入任务信息(ImportTask)表数据库访问层
 *
 * @author sunx
 * @date 2022-05-12 09:25:17
 */
public interface ImportTaskMapper extends BaseMapper<ImportTask> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<ImportTask> findByConditions(
      Page<ImportTask> page, @Param("dto") ImportTaskPaginationDto dto);

  /**
   * 根据ImportTaskModelDto获取任务信息(主要用于加载任务)
   *
   * @param dto
   * @return
   */
  List<ImportTask> findByImportTaskModelDto(@Param("dto") ImportTaskModelDto dto);
}
