package com.biz.crm.common.ie.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.model.vo.ImportTreeModelVo;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 导入模板主表(ImportTemplate)表服务接口
 *
 * @author sunx
 * @date 2022-05-10 10:27:58
 */
public interface ImportTemplateService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<ImportTemplate> findByConditions(Pageable pageable, ImportTemplatePaginationDto dto);

  /**
   * 根据业务编码获取详情
   *
   * @param businessCode 业务编码
   * @return
   */
  ImportTemplate findDetailByBusinessCode(String businessCode);

  /**
   * 创建
   *
   * @param importTemplate 导入模板
   * @return
   */
  ImportTemplate create(ImportTemplate importTemplate);

  /**
   * 更新
   *
   * @param importTemplate 导入模板
   * @return
   */
  ImportTemplate update(ImportTemplate importTemplate);

  /**
   * 根据业务编码集合删除
   *
   * @param businessCodes 业务编码集合
   */
  void deleteByBusinessCodes(List<String> businessCodes);

  /**
   * 获取模板管理业务-模板下拉树
   *
   * @return
   */
  List<ImportTreeModelVo> findTemplateTree();

  /**
   * 根据业务编码获取下级模板下拉
   *
   * @param businessCode 业务编码
   * @return
   */
  List<ImportTreeModelVo> findTemplateSelectByBusinessCode(String businessCode);
}
