/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.bean;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.biz.crm.common.ie.sdk.dto.ExportTaskQueueDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportDetailProcessEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.biz.crm.common.ie.sdk.vo.ExportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExportSendProcessMsgBean {
    private static final Logger log = LoggerFactory.getLogger(ExportSendProcessMsgBean.class);
    @Value(value="${spring.application.name}")
    private String applicationName;
    @Autowired(required=false)
    private ChannelMsgService channelMsgService;
    private static final String IE_EXPORT_MODEL_CODE = "ie_export_model";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportSendProcessMsgBean.class);

    public void sendTaskProcessMsg(String taskCode, String execStatus, ExportProcessEnum process, String account, Boolean mainFlag) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setMainFlag(mainFlag);
        vo.setExecStatus(execStatus);
        vo.setProcessType(process.getCode());
        vo.setRemark(process.getFormat());
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendMsg(vo);
    }

    public void sendTaskProcessMsg(ExportTaskProcessVo task, String execStatus, ExportProcessEnum process, String account, Boolean mainFlag) {
        String taskCode = task.getTaskCode();
        this.sendTaskProcessMsg(taskCode, execStatus, process, account, mainFlag);
    }

    public void sendTaskProcessMsg(ExportTaskProcessVo task, String execStatus, ExportProcessEnum process, Integer cursor, String account, Boolean mainFlag) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(mainFlag != false ? task.getTaskCode() : task.getDetailCode());
        vo.setMainFlag(mainFlag);
        vo.setExecStatus(execStatus);
        vo.setProcessType(process.getCode());
        vo.setRemark(process.getFormat());
        vo.setPageSize(Integer.valueOf(100));
        vo.setCursor(cursor);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendMsg(vo);
    }

    public void sendTaskProcessMsg(ExportTaskProcessVo task, String execStatus, ExportProcessEnum process, Integer cursor, String account, Boolean mainFlag, String fileCode) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(mainFlag != false ? task.getTaskCode() : task.getDetailCode());
        vo.setMainFlag(mainFlag);
        vo.setExecStatus(execStatus);
        vo.setProcessType(process.getCode());
        vo.setRemark(process.getFormat());
        vo.setPageSize(Integer.valueOf(100));
        vo.setCursor(cursor);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        if (mainFlag.booleanValue()) {
            vo.setFileCode(fileCode);
        }
        this.sendMsg(vo);
    }

    public void sendSubTaskProcessMsg(ExportTaskProcessVo task, String execStatus, ExportProcessEnum process, Integer cursor, String account) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(task.getDetailCode());
        vo.setMainFlag(Boolean.valueOf(false));
        vo.setExecStatus(execStatus);
        vo.setProcessType(process.getCode());
        vo.setRemark(process.getFormat());
        vo.setPageSize(Integer.valueOf(100));
        vo.setCursor(cursor);
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendMsg(vo);
    }

    public void sendDetailTaskProcessMsg(String detailCode, String execStatus, ExportDetailProcessEnum process, String account) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(detailCode);
        vo.setExecStatus(execStatus);
        vo.setProcessType(process.getCode());
        vo.setRemark(process.getFormat());
        vo.setAccount(account);
        vo.setApplicationName(this.applicationName);
        this.sendMsg(vo);
    }

    public void sendStartProcessMsg(ExportTaskProcessVo task, ExportDetailProcessEnum detailProcess, ExportProcessEnum process, String account) {
        String[] str;
        for (String item : str = task.getDetailCode().split("_")) {
            if (!"0".equals(item)) continue;
            ExportProcessMsgVo mainVo = new ExportProcessMsgVo();
            mainVo.setTaskCode(task.getTaskCode());
            mainVo.setMainFlag(Boolean.valueOf(true));
            mainVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            mainVo.setProcessType(process.getCode());
            mainVo.setRemark(process.getFormat());
            mainVo.setPageSize(Integer.valueOf(100));
            mainVo.setCursor(Integer.valueOf(0));
            mainVo.setAccount(account);
            mainVo.setApplicationName(this.applicationName);
            this.sendMsg(mainVo);
        }
        ExportProcessMsgVo detailVo = new ExportProcessMsgVo();
        detailVo.setTaskCode(task.getDetailCode());
        detailVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
        detailVo.setProcessType(detailProcess.getCode());
        detailVo.setRemark(detailProcess.getFormat());
        detailVo.setPageSize(task.getTotal());
        detailVo.setCursor(Integer.valueOf(0));
        detailVo.setMainFlag(Boolean.valueOf(false));
        detailVo.setAccount(account);
        detailVo.setApplicationName(this.applicationName);
        this.sendMsg(detailVo);
    }

    public void sendFailedProcessMsg(String taskCode, Boolean mainFlag, String msg, String account) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(taskCode);
        vo.setMainFlag(mainFlag);
        vo.setIeType(TypeEnum.EXPORT.getDictCode());
        vo.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        vo.setProcessType(ExportProcessEnum.END.getCode());
        vo.setRemark(msg);
        vo.setAccount(account);
        vo.setCursor(Integer.valueOf(0));
        vo.setApplicationName(this.applicationName);
        this.sendMsg(vo);
    }

    public void sendTaskProcessQueueMsg(ExportTaskQueueDto task, Integer sort) {
        ExportProcessMsgVo vo = new ExportProcessMsgVo();
        vo.setTaskCode(task.getTaskCode());
        vo.setMainFlag(Boolean.valueOf(task.isMainFlag()));
        vo.setRemark("\u5f53\u524d\u6392\u961f\u987a\u5e8f...");
        vo.setAccount(task.getAccount());
        vo.setTaskSort(sort);
        this.sendMsg(vo);
    }

    public void sendMsg(ExportProcessMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String ieChannelTaskCode = "CRM_ALL";
        String exportAndImportModelCode = "ie_export_import_model";
        LOGGER.info(" export model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, IE_EXPORT_MODEL_CODE});
        if (StringUtils.isNotBlank((CharSequence)vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, this.applicationName, IE_EXPORT_MODEL_CODE, vo.getAccount(), jsonBytes);
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, ieChannelTaskCode, exportAndImportModelCode, vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, this.applicationName, IE_EXPORT_MODEL_CODE, jsonBytes);
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, ieChannelTaskCode, exportAndImportModelCode, jsonBytes);
        }
    }

    public void sendMsgByAll(ExportProcessMsgVo vo) {
        vo.setTime(new Date());
        byte[] jsonBytes = JSONObject.toJSONBytes((Object)vo, (SerializerFeature[])new SerializerFeature[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String ieChannelTaskCode = "CRM_ALL";
        String exportAndImportModelCode = "ie_export_import_model";
        LOGGER.info(" export model send msg: tenantCode = {} , applicationName = {} , modelCode = {} ", new Object[]{tenantCode, this.applicationName, IE_EXPORT_MODEL_CODE});
        if (StringUtils.isNotBlank((CharSequence)vo.getAccount())) {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCodeAndAccount(tenantCode, ieChannelTaskCode, exportAndImportModelCode, vo.getAccount(), jsonBytes);
        } else {
            this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, ieChannelTaskCode, exportAndImportModelCode, jsonBytes);
        }
    }
}

