/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.mapper.ImportTaskMapper;
import com.biz.crm.common.ie.local.model.dto.ImportTaskModelDto;
import com.biz.crm.common.ie.local.model.vo.ImportTaskUpdateModelVo;
import com.biz.crm.common.ie.sdk.dto.ImportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.CallbackStatusEnum;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.datasource.configuration.MultiDataSourceProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ImportTaskRepository
extends ServiceImpl<ImportTaskMapper, ImportTask> {
    @Autowired
    private MultiDataSourceProperties multiDataSourceProperties;

    public Page<ImportTask> findByConditions(Page<ImportTask> page, ImportTaskPaginationDto dto) {
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            dto.setAppCode(TenantUtils.getAppCode());
        }
        return ((ImportTaskMapper)this.baseMapper).findByConditions(page, dto);
    }

    public ImportTask findById(String id) {
        return (ImportTask)((Object)((ImportTaskMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public ImportTask findByTaskCode(String taskCode) {
        LambdaQueryChainWrapper lambdaQuery = this.lambdaQuery();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaQuery.eq(ImportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        return (ImportTask)((Object)((LambdaQueryChainWrapper)lambdaQuery.eq(ImportTask::getTaskCode, (Object)taskCode)).one());
    }

    public void updateByImportTaskUpdateModelVo(ImportTaskUpdateModelVo vo) {
        if (vo == null || StringUtils.isBlank((CharSequence)vo.getTaskCode())) {
            return;
        }
        ImportTask importTask = this.findByTaskCode(vo.getTaskCode());
        importTask.setExecStatus(vo.getExecStatus());
        if (Objects.nonNull(vo.getTotal())) {
            importTask.setTotal(vo.getTotal());
        }
        if (Objects.nonNull(vo.getFailedNum())) {
            importTask.setFailedNum(vo.getFailedNum());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getFailedFileCode())) {
            importTask.setFailedFileCode(vo.getFailedFileCode());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getRemark())) {
            importTask.setRemark(vo.getRemark());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getLoadStatus())) {
            importTask.setLoadStatus(vo.getLoadStatus());
        }
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            importTask.setAppCode(TenantUtils.getAppCode());
        }
        this.updateById((Object)importTask);
    }

    public void updateLocalStatus(Set<String> taskCodes, String loadStatus) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ImportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(ImportTask::getTaskCode, taskCodes)).set(ImportTask::getLoadStatus, (Object)loadStatus)).update();
    }

    public void updateCallBackStatusByIds(List<String> ids, CallbackStatusEnum callbackStatusEnum) {
        LambdaUpdateChainWrapper lambdaUpdate = this.lambdaUpdate();
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            lambdaUpdate.eq(ImportTask::getAppCode, (Object)TenantUtils.getAppCode());
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)lambdaUpdate.in(UuidEntity::getId, ids)).set(ImportTask::getCallBackStatus, (Object)callbackStatusEnum.getDictCode())).update();
    }

    public List<ImportTask> findByImportTaskModelDto(ImportTaskModelDto dto) {
        if (this.multiDataSourceProperties.getSchemaForTenant().booleanValue()) {
            dto.setAppCode(TenantUtils.getAppCode());
        }
        return ((ImportTaskMapper)this.baseMapper).findByImportTaskModelDto(dto);
    }
}

