/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.strategy;

import com.alibaba.excel.write.handler.RowWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.biz.crm.common.ie.local.model.ExportExcelHeadModel;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;

public class DynamicImageWriteHandler
implements RowWriteHandler {
    private static final Logger log = LoggerFactory.getLogger(DynamicImageWriteHandler.class);
    private static final int SINGLE_IMAGE_SIZE = 100;
    private static final int SINGLE_IMAGE_PADDING = 5;
    private static final int MAX_IMAGES_PER_ROW = 3;
    private static byte[] LOAD_FAIL_IMAGE_BYTES = null;
    private final ExportExcelHeadModel excelHeadModel;
    private final FileHandleService fileHandleService;
    private final Map<Integer, Integer> imageColumnMaxWidthMap = Maps.newHashMap();

    public DynamicImageWriteHandler(ExportExcelHeadModel excelHeadModel, FileHandleService fileHandleService) {
        this.excelHeadModel = excelHeadModel;
        this.fileHandleService = fileHandleService;
    }

    public void afterRowDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Integer relativeRowIndex, Boolean isHead) {
        if (isHead.booleanValue() || CollectionUtils.isEmpty(this.excelHeadModel.getImageDataIndexList())) {
            return;
        }
        int maxRowHeight = 100;
        for (Integer imageDataIndex : this.excelHeadModel.getImageDataIndexList()) {
            String fileCodeStr;
            Cell imageCell = row.getCell(imageDataIndex.intValue());
            if (!CellType.STRING.equals((Object)imageCell.getCellType()) || StringUtils.isBlank((CharSequence)(fileCodeStr = imageCell.getStringCellValue()))) continue;
            imageCell.setCellValue("");
            Object[] fileCodes = fileCodeStr.split(",");
            List fileVoList = this.fileHandleService.findByIds((List)Lists.newArrayList((Object[])fileCodes));
            fileVoList = (List)ObjectUtils.defaultIfNull((Object)fileVoList, (Object)Lists.newArrayList());
            Map ordinaryFileVoMap = fileVoList.stream().collect(Collectors.toMap(OrdinaryFileVo::getId, Function.identity(), (a, b) -> a));
            List<byte[]> images = Arrays.stream(fileCodes).map(fileCode -> {
                byte[] bytes = null;
                OrdinaryFileVo ordinaryFileVo = (OrdinaryFileVo)ordinaryFileVoMap.get(fileCode);
                if (Objects.nonNull(ordinaryFileVo)) {
                    bytes = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
                }
                return Objects.isNull(bytes) || bytes.length == 0 ? LOAD_FAIL_IMAGE_BYTES : bytes;
            }).collect(Collectors.toList());
            int magesPerRow = Math.min(images.size(), 3);
            int rowsNeeded = (int)Math.ceil((double)images.size() / (double)magesPerRow);
            int totalWidthPx = 100 * magesPerRow;
            int totalHeightPx = 100 * rowsNeeded;
            int columnWidth = (int)((float)(totalWidthPx * 256) / 7.0017f);
            int mapColumnWidth = Math.max(this.imageColumnMaxWidthMap.getOrDefault(imageDataIndex, columnWidth), columnWidth);
            this.imageColumnMaxWidthMap.put(imageDataIndex, mapColumnWidth);
            imageCell.getSheet().setColumnWidth(imageDataIndex.intValue(), mapColumnWidth);
            maxRowHeight = Math.max(maxRowHeight, totalHeightPx);
            this.embedImages(imageDataIndex, writeSheetHolder.getSheet(), row, images, magesPerRow);
        }
        row.setHeightInPoints((float)((double)maxRowHeight * 72.0 / 96.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void embedImages(int imageDataIndex, Sheet sheet, Row row, List<byte[]> imageBytesList, int magesPerRow) {
        for (int imageIndex = 0; imageIndex < imageBytesList.size(); ++imageIndex) {
            byte[] imageBytes = imageBytesList.get(imageIndex);
            Drawing drawing = sheet.createDrawingPatriarch();
            int gridRow = imageIndex / magesPerRow;
            int gridCol = imageIndex % magesPerRow;
            ByteArrayInputStream imageByteArrayInputStream = null;
            ByteArrayInputStream failImageByteArrayInputStream = null;
            try {
                double scaledHeight;
                double scaledWidth;
                double aspectRatio;
                imageByteArrayInputStream = new ByteArrayInputStream(imageBytes);
                BufferedImage bufferedImage = ImageIO.read(imageByteArrayInputStream);
                if (Objects.isNull(bufferedImage)) {
                    imageBytes = LOAD_FAIL_IMAGE_BYTES;
                    failImageByteArrayInputStream = new ByteArrayInputStream(imageBytes);
                    bufferedImage = ImageIO.read(failImageByteArrayInputStream);
                }
                if ((aspectRatio = (double)bufferedImage.getWidth() / (double)bufferedImage.getHeight()) > 1.0) {
                    scaledWidth = 90.0;
                    scaledHeight = scaledWidth / aspectRatio;
                } else {
                    scaledHeight = 90.0;
                    scaledWidth = scaledHeight * aspectRatio;
                }
                double offsetX = (100.0 - scaledWidth) / 2.0 + (double)(gridCol * 100);
                double offsetY = (100.0 - scaledHeight) / 2.0 + (double)(gridRow * 100);
                Workbook workbook = sheet.getWorkbook();
                ClientAnchor anchor = workbook.getCreationHelper().createClientAnchor();
                anchor.setDx1((int)(offsetX * 9525.0));
                anchor.setDy1((int)(offsetY * 9525.0));
                anchor.setDx2((int)((offsetX + scaledWidth) * 9525.0));
                anchor.setDy2((int)((offsetY + scaledHeight) * 9525.0));
                anchor.setCol1(imageDataIndex);
                anchor.setRow1(row.getRowNum());
                anchor.setCol2(imageDataIndex);
                anchor.setRow2(row.getRowNum());
                int picIndex = workbook.addPicture(imageBytes, 5);
                drawing.createPicture(anchor, picIndex);
                continue;
            }
            catch (Exception e) {
                log.error("\u56fe\u7247\u7ed1\u5b9a\u5355\u5143\u683c\u5931\u8d25...", (Throwable)e);
                continue;
            }
            finally {
                try {
                    if (Objects.nonNull(imageByteArrayInputStream)) {
                        imageByteArrayInputStream.close();
                    }
                    if (Objects.nonNull(failImageByteArrayInputStream)) {
                        failImageByteArrayInputStream.close();
                    }
                }
                catch (Exception e) {
                    log.error("\u91ca\u653e\u8d44\u6e90\u5931\u8d25...", (Throwable)e);
                }
            }
        }
    }

    static {
        try (InputStream inputStream = ResourceLoader.class.getClassLoader().getResourceAsStream("load_fail_image.png");){
            if (Objects.nonNull(inputStream)) {
                LOAD_FAIL_IMAGE_BYTES = IOUtils.toByteArray((InputStream)inputStream);
            } else {
                log.error("\u52a0\u8f7d\u5bfc\u51fa\u9ed8\u8ba4\u5931\u8d25\u56fe\u7247\u5931\u8d25");
            }
        }
        catch (Exception e) {
            log.error("\u52a0\u8f7d\u5bfc\u51fa\u9ed8\u8ba4\u5931\u8d25\u56fe\u7247\u5f02\u5e38", (Throwable)e);
        }
    }
}

