package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导出任务(ExportTask)实体类
 *
 * @author sunx
 * @since 2022-05-18 16:31:04
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_export_task")
@Table(
    name = "ie_export_task",
    indexes = {
      @Index(name = "ie_e_t_idx1", columnList = "task_code", unique = true),
      @Index(name = "ie_e_t_idx2", columnList = "exec_status"),
      @Index(name = "ie_e_t_idx3", columnList = "create_time"),
    })
@ApiModel(value = "ExportTask", description = "导出任务")
@org.hibernate.annotations.Table(appliesTo = "ie_export_task", comment = "导出任务")
public class ExportTask extends TenantFlagOpEntity {
  private static final long serialVersionUID = 2028896696420749594L;

  /** 导出任务编码 */
  @ApiModelProperty("导出任务编码")
  @TableField(value = "task_code")
  @Column(name = "task_code", length = 64, columnDefinition = "varchar(64) COMMENT '导出任务编码'")
  private String taskCode;

  /** 任务名称 */
  @ApiModelProperty("任务名称")
  @TableField(value = "task_name")
  @Column(name = "task_name", length = 64, columnDefinition = "varchar(64) COMMENT '任务名称'")
  private String taskName;

  /** 业务编码 */
  @ApiModelProperty("业务编码")
  @TableField(value = "business_code")
  @Column(name = "business_code", length = 64, columnDefinition = "varchar(64) COMMENT '业务编码'")
  private String businessCode;

  /** 文件来源 */
  @ApiModelProperty("文件来源")
  @TableField(value = "task_source")
  @Column(name = "task_source", length = 255, columnDefinition = "varchar(255) COMMENT '文件来源'")
  private String taskSource;

  /** 总记录数 */
  @ApiModelProperty("总记录数")
  @TableField(value = "total")
  @Column(name = "total", length = 11, columnDefinition = "int(11) COMMENT '总记录数'")
  private Integer total;

  /** 导出任务全局参数 */
  @ApiModelProperty("导出任务全局参数")
  @TableField(value = "parameters_json")
  @Column(
      name = "parameters_json",
      length = 800,
      columnDefinition = "varchar(800) COMMENT '导出任务全局参数'")
  private String parametersJson;

  /** 任务执行状态 */
  @ApiModelProperty("任务执行状态")
  @TableField(value = "exec_status")
  @Column(name = "exec_status", length = 64, columnDefinition = "varchar(64) COMMENT '任务执行状态'")
  private String execStatus;

  /** 应用名称 */
  @ApiModelProperty("应用名称")
  @TableField(value = "application_name")
  @Column(name = "application_name", length = 64, columnDefinition = "varchar(64) COMMENT '应用名称'")
  private String applicationName;

  /** 顶级租户编码 */
  @ApiModelProperty("顶级租户编码")
  @TableField(value = "app_code")
  @Column(name = "app_code", length = 64, columnDefinition = "varchar(64) COMMENT '顶级租户编码'")
  private String appCode;

  /** 数据权限控制所需要的，由head信息携带的MARS_LIST_CODE */
  @ApiModelProperty("数据权限控制所需要的，由head信息携带的MARS_LIST_CODE")
  @TableField(value = "mars_list_code")
  @Column(name = "mars_list_code" , nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '数据权限控制所需要的，由head信息携带的MARS_LIST_CODE'")
  private String marsListCode;

  /** 个性化设置以及导出字段需要使用菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用菜单编号")
  @TableField(value = "function_code")
  @Column(name = "function_code" , nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '个性化设置以及导出字段需要使用菜单编号，由head信息携带的MARS_LIST_CODE'")
  private String functionCode;

  /** 个性化设置以及导出字段需要使用上级菜单编号 */
  @ApiModelProperty("个性化设置以及导出字段需要使用上级菜单编号")
  @TableField(value = "parent_code")
  @Column(name = "parent_code" , nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '个性化设置以及导出字段需要使用上级菜单编号，由head信息携带的MARS_LIST_CODE'")
  private String parentCode;

  /** 回调状态-执行成功或者失败回调状态 */
  @ApiModelProperty("回调状态-执行成功或者失败回调状态")
  @TableField(value = "call_back_status")
  @Column(name = "call_back_status", length = 32, columnDefinition = "varchar(32) COMMENT '回调状态-执行成功或者失败回调状态'")
  private String callBackStatus;

  /** 子任务 */
  @ApiModelProperty("子任务")
  @Transient
  @TableField(exist = false)
  private List<ExportTaskDetail> list;

  /** 文件信息 */
  @ApiModelProperty("文件信息")
  @Transient
  @TableField(exist = false)
  private List<ExportTaskRelateFile> fileList;

  /** 是否是主任务 */
  @ApiModelProperty("是否是主任务")
  @Transient
  @TableField(exist = false)
  private Boolean mainFlag = true;

  /** 导出文件名称 */
  @ApiModelProperty("导出文件名称")
  @TableField(value = "file_name")
  @Column(name = "file_name", length = 255, columnDefinition = "varchar(255) COMMENT '导出文件名称'")
  private String fileName;
  
  @ApiModelProperty("异步获取任务总数")
  @Transient
  @TableField(exist = false)
  private Boolean asyncGetTotal = false;

  /**
   * 请求的url地址
   */
  @ApiModelProperty("请求的url地址")
  @TableField(value = "web_api_url")
  @Column(name = "web_api_url",length = 255,columnDefinition = "varchar(255) comment '请求的url地址'")
  private String webApiUrl;
}
