package com.biz.crm.common.ie.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.model.dto.ExportTaskConditionModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.annotations.Param;

/**
 * 导出任务(ExportTask)表数据库访问层
 *
 * @author sunx
 * @date 2022-05-18 16:31:04
 */
public interface ExportTaskMapper extends BaseMapper<ExportTask> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<ExportTask> findByConditions(
      Page<ExportTask> page, @Param("dto") ExportTaskPaginationDto dto);

  /**
   * 获取没有执行的任务数量
   * 
   * @param dto 根据对象的创建日期，查询出状态为待执行和未执行中的数据
   * @param createTimeForBegin 起始时间
   * @return
   */
  Integer getTaskCountByNoExe(@Param("dto") ExportTask dto, @Param("createTimeForBegin") Date createTimeForBegin);

  /**
   * 获取没有初始化的任务（total=null）
   * 
   * @param dto
   * @return
   */
  List<ExportTask> findExportTaskNoGetTotal(@Param("dto") ExportTaskModelDto dto,
      @Param("createTimeForBegin") Date createTimeForBegin);

  /**
   * 条件查询导出任务
   *
   * @param dto
   * @return
   */
  List<ExportTask> findByExportTaskConditionModelDto(@Param("dto") ExportTaskConditionModelDto dto);
}
