package com.biz.crm.common.ie.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskProcessModelDto;
import com.biz.crm.common.ie.sdk.dto.CreateExportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import java.util.Set;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 导出任务(ExportTask)表服务接口
 *
 * @author sunx
 * @date 2022-05-18 16:31:05
 */
public interface ExportTaskService {

  /**
   * 分页条件查询
   *
   * @param pageable 分页
   * @param dto 查询参数
   * @return
   */
  Page<ExportTask> findByConditions(Pageable pageable, ExportTaskPaginationDto dto);

  /**
   * 导出文件管理-取消导出任务
   * @param codes
   */
  void cancelTask(List<String> codes);

  /**
   * 根据任务编码获取详情（包含子任务和文件信息）
   *
   * @param taskCode 任务编码
   * @return
   */
  ExportTask findDetailByTaskCode(String taskCode);
  
  /**
   * 根据任务编码获取任务（不包含子任务和文件信息）
   * @param taskCode
   * @return
   */
  ExportTask findExportTask(String taskCode);
  /**
   * 创建导出任务
   *
   * @param dto 导出任务
   * @return
   */
  ExportTask create(CreateExportTaskDto dto);

  /**
   * 根据子任务编码获取处理任务信息
   *
   * @param detailCode 子任务编码
   * @return
   */
  ExportTaskProcessVo findExportTaskModelVoByDetailCode(String detailCode);

  /**
   * 任务处理结束更新任务状态
   *
   * @param dto 导出任务结束更新主任务信息model实体
   */
  void updateByExportTaskProcessModelDto(ExportTaskProcessModelDto dto);
  
  /**
   * 获取没有执行的任务数量
   * 
   * @param dto 根据对象的创建日期，查询出状态为待执行和未执行中的数据
   * @return
   */
  int getTaskCountByNoExe(ExportTask current);
  
  /**
   * 失败时，更新执行状态,备注
   * @param dto
   */
  void updateExecStatus(ExportTaskProcessModelDto dto);

  /**
   * 批量更新任务执行状态
   * @param applicationName 
   * @param execStatusEnum
   * @param taskCodeArray
   */
  void updateExecStatus(String applicationName, ExecStatusEnum execStatusEnum, String... taskCodeArray);

  /**
   * 批量更新任务执行状态(包括子任务)
   * @param execStatusEnum
   * @param taskCodes
   */
  void updateExecStatusContainsDetail(ExecStatusEnum execStatusEnum, Set<String> taskCodes);

  /**
   * 获取总数为null，指定状态的任务列表
   * @param dto
   * @return
   */
  List<ExportTask> findExportTaskNoGetTotal(ExportTaskModelDto dto);

  /**
   * 获取ES待分段的导出任务
   *
   * @param dto
   * @return
   */
  List<ExportTask> findExportTaskNoEsParagraph(ExportTaskModelDto dto);

  /**
   * 执行导出任务获取总数
   *
   * @param exportTask 导出任务
   * @return 导出任务
   */
  void execExportGetTotal(ExportTask exportTask);

  /**
   * 执行导出任务ES分段
   *
   * @param exportTask 导出任务
   * @return 导出任务
   */
  void execExportEsParagraph(ExportTask exportTask);
}
