package com.biz.crm.common.ie.local.service;

import java.util.Map;
import java.util.Set;

/**
 * 导入导出线程池接口
 *
 * @author sunx
 * @date 2022/6/23
 */
public interface ImportExportTaskPoolService {

  /**
   * 加载任务
   *
   * @param poolName 线程池名称
   * @param taskCode 任务编码
   * @param ieType 导入导出类型
   */
  void reloadTask(String poolName, String taskCode, String ieType, String applicationName);

  /**
   * 获取线程池信息
   *
   * @param name 线程池名称
   * @param ieType 导入导出类型
   * @return
   */
  Map<String, Object> findDashboard(String name, String ieType);

  /**
   * 获取线程池名字
   *
   * @return
   */
  Map<String, Set<String>> findPoolNames();
}
