/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.listener;

import cn.hutool.json.JSONUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.enums.RowTypeEnum;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.biz.crm.common.ie.local.listener.ObjectUtils;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Validate;

public class EasyExcelListener
extends AnalysisEventListener<Object> {
    private boolean whetherSkipBlankLines;
    private Integer limitRowNum;
    List<Object> list = new ArrayList<Object>();

    public EasyExcelListener() {
        this.whetherSkipBlankLines = false;
        this.limitRowNum = ImportExportConstant.IE_IMPORT_LIMIT_ROW_NUM;
    }

    public EasyExcelListener(boolean whetherSkipBlankLines) {
        this.whetherSkipBlankLines = whetherSkipBlankLines;
        this.limitRowNum = ImportExportConstant.IE_IMPORT_LIMIT_ROW_NUM;
    }

    public EasyExcelListener(boolean whetherSkipBlankLines, Integer limitRowNum) {
        this.whetherSkipBlankLines = whetherSkipBlankLines;
        this.limitRowNum = limitRowNum;
    }

    public void invokeHead(Map<Integer, ReadCellData<?>> headMap, AnalysisContext context) {
        super.invokeHead(headMap, context);
        int totalRowNumber = context.readSheetHolder().getApproximateTotalRowNumber() - context.readSheetHolder().getHeadRowNumber();
        Validate.isTrue((Objects.isNull(this.limitRowNum) || this.limitRowNum >= totalRowNumber ? 1 : 0) != 0, (String)"\u5bfc\u5165\u5931\u8d25, \u5bfc\u5165\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7%s\u884c", (long)this.limitRowNum.intValue());
    }

    public void invoke(Object t, AnalysisContext analysisContext) {
        analysisContext.readWorkbookHolder().setIgnoreEmptyRow(Boolean.valueOf(this.whetherSkipBlankLines));
        if (this.whetherSkipBlankLines && ObjectUtils.checkObjAllFieldsIsNull(t)) {
            return;
        }
        this.list.add(t);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
    }

    public <T> List<T> getList(Class<T> obj) {
        String jsonObj = JSONUtil.toJsonStr(this.list);
        return JSONUtil.toList((String)jsonObj, obj);
    }

    public boolean hasNext(AnalysisContext analysisContext) {
        if (RowTypeEnum.EMPTY.equals((Object)analysisContext.readRowHolder().getRowType())) {
            this.doAfterAllAnalysed(analysisContext);
            return true;
        }
        return super.hasNext(analysisContext);
    }
}

