/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.strategy;

import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.biz.crm.common.ie.local.model.vo.ImportExcelReadModelVo;
import com.biz.crm.common.ie.sdk.enums.WriteErrorExcelModelEnums;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.biz.crm.common.ie.sdk.strategy.ImportExcelStrategy;
import com.biz.crm.common.ie.sdk.vo.ExcelItemVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrmImportExcelReadListener
extends AnalysisEventListener<Map<Integer, Object>> {
    private static final Logger log = LoggerFactory.getLogger(CrmImportExcelReadListener.class);
    private ImportExcelReadModelVo readVo;
    private ExcelWriter excelWriter;
    private WriteSheet writeSheet;
    private int failedNum = 0;
    private int successNum = 0;
    private int cursor = 0;
    private List<List<Object>> cachedDataList = Lists.newLinkedList();
    private Map<Integer, String> cacheErr = Maps.newHashMap();
    private Map<Integer, String> headMaps = Maps.newHashMap();
    private LinkedHashMap<Integer, CrmExcelVo> cacheData = Maps.newLinkedHashMap();
    private int cacheCursor = 0;
    private String account;
    private ImportExcelStrategy importExcelStrategy;

    public CrmImportExcelReadListener(ImportExcelReadModelVo readVo, ExcelWriter excelWriter, WriteSheet writeSheet, String account, ImportExcelStrategy importExcelStrategy) {
        this.readVo = readVo;
        this.excelWriter = excelWriter;
        this.writeSheet = writeSheet;
        this.account = account;
        this.importExcelStrategy = importExcelStrategy;
    }

    public void invoke(Map<Integer, Object> data, AnalysisContext context) {
        if (this.readVo.getProcess().getBatchCount().compareTo(0) <= 0) {
            return;
        }
        if (this.cacheCursor == this.readVo.getProcess().getBatchCount()) {
            this.execute();
        }
        List<Object> cur = this.findData(data);
        this.cachedDataList.add(cur);
        ++this.cursor;
        try {
            CrmExcelVo o = (CrmExcelVo)this.readVo.getProcess().findCrmExcelVoClass().newInstance();
            this.importExcelStrategy.setCrmExcelVoValue(o, data, this.headMaps);
            this.cacheData.put(this.cacheCursor++, o);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            e.printStackTrace();
            cur.add(e.getMessage());
            this.cacheErr.put(this.cacheCursor++, e.getMessage());
            ++this.failedNum;
        }
        catch (Exception e) {
            e.printStackTrace();
            cur.add("\u6570\u636e\u5f02\u5e38");
            this.cacheErr.put(this.cacheCursor++, "\u6570\u636e\u5f02\u5e38");
            ++this.failedNum;
        }
        this.sendProcessMsg(true);
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.execute();
        this.sendProcessMsg(false);
        this.readVo.setSuccessNum(this.successNum);
        this.readVo.setFailedNum(this.failedNum);
    }

    private void execute() {
        if (this.cacheData == null || this.cacheData.isEmpty()) {
            return;
        }
        Map map = null;
        ImportProcess<CrmExcelVo> process = this.readVo.getProcess();
        try {
            map = process.execute(this.cacheData, this.readVo.getParamsVo(), this.readVo.getParams());
            map = Optional.ofNullable(map).orElse(Maps.newHashMap());
            long count = 0L;
            if (map.isEmpty()) {
                count = this.cacheData.size();
            } else {
                Set<Integer> set = this.cacheData.keySet();
                Map finalMap = map;
                count = set.parallelStream().filter(a -> !finalMap.keySet().contains(a)).count();
            }
            this.successNum += new Long(count).intValue();
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException e) {
            log.error("[1]\u76f4\u63a5\u4fdd\u5b58\u5f02\u5e38", (Throwable)e);
            for (Integer item : this.cacheData.keySet()) {
                this.cacheErr.put(item, "\u5904\u7406\u5f02\u5e38:" + e.getMessage());
                ++this.failedNum;
            }
        }
        catch (Exception e) {
            log.error("[1]\u76f4\u63a5\u4fdd\u5b58\u6821\u9a8c\u5f02\u5e38", (Throwable)e);
            for (Integer item : this.cacheData.keySet()) {
                this.cacheErr.put(item, "\u5904\u7406\u5f02\u5e38");
                ++this.failedNum;
            }
        }
        if (map != null && !map.isEmpty()) {
            for (Map.Entry item : map.entrySet()) {
                this.cacheErr.put((Integer)item.getKey(), "\u5904\u7406\u5f02\u5e38:" + (String)item.getValue());
                ++this.failedNum;
            }
        }
        WriteErrorExcelModelEnums writeErrorExcelModel = process.getWriteErrorExcelModel();
        this.writeErrorExcel(writeErrorExcelModel);
        this.resetCache();
    }

    private void writeErrorExcel(WriteErrorExcelModelEnums writeErrorExcelModel) {
        int i = 0;
        LinkedList errDataList = Lists.newLinkedList();
        block3: for (List<Object> item : this.cachedDataList) {
            String errMsg = this.cacheErr.get(i++);
            switch (writeErrorExcelModel) {
                case ALL_ROW: {
                    if (StringUtils.isNotBlank((CharSequence)errMsg)) {
                        item.add(errMsg.trim());
                    } else {
                        item.add("\u5bfc\u5165-\u6210\u529f");
                    }
                    errDataList.add(item);
                    continue block3;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)errMsg)) continue;
            item.add(errMsg.trim());
            errDataList.add(item);
        }
        if (CollectionUtils.isEmpty((Collection)errDataList)) {
            return;
        }
        this.excelWriter.write((Collection)errDataList, this.writeSheet);
    }

    private List<Object> findData(Map<Integer, Object> data) {
        if (data == null || data.isEmpty()) {
            return Lists.newLinkedList();
        }
        LinkedList items = Lists.newLinkedList();
        for (Map.Entry<Integer, Object> item : data.entrySet()) {
            ExcelItemVo cur = new ExcelItemVo();
            cur.setColumn(item.getKey());
            cur.setData(item.getValue());
            items.add(cur);
        }
        return items.stream().sorted(Comparator.comparing(ExcelItemVo::getColumn)).map(ExcelItemVo::getData).collect(Collectors.toList());
    }

    private void resetCache() {
        this.cacheCursor = 0;
        this.cachedDataList = Lists.newLinkedList();
        this.cacheErr = Maps.newHashMap();
        this.cacheData = Maps.newLinkedHashMap();
        this.headMaps = Maps.newHashMap();
    }

    private void sendProcessMsg(Boolean processFlag) {
        if (Boolean.TRUE.equals(processFlag) && this.cursor % 10 != 0) {
            return;
        }
        log.info("\u4efb\u52a1{},\u7b2c1\u9875,\u603b\u8ba1{},\u5f53\u524d\u8fdb\u5ea6{},\u6210\u529f{},\u5931\u8d25{}", new Object[]{this.readVo.getParamsVo().getTaskCode(), this.readVo.getTotal(), this.cursor, this.successNum, this.failedNum});
        this.readVo.getMsgBean().sendProcessMsg(this.readVo.getParamsVo().getTaskCode(), this.readVo.getTotal(), this.cursor, this.successNum, this.failedNum, this.account);
    }

    public void invokeHeadMap(Map<Integer, String> headMap, AnalysisContext context) {
        this.headMaps.putAll(headMap);
    }
}

