/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.net.NetUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.ImportExportLoadTask;
import com.biz.crm.common.ie.local.service.task.ImportExportReloadTask;
import com.biz.crm.common.ie.local.util.IpUtil;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component(value="_ImportExportMasterKeeperTask")
public class ImportExportMasterKeeperTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ImportExportMasterKeeperTask.class);
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private ImportExportLoadTask importExportLoadTask;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private RedisTemplate redisTemplate;
    @Autowired
    private Environment environment;
    @Autowired
    private ImportExportProperties importExportProperties;

    @Override
    public void run() {
        String appName = this.importExportProperties.getIeTaskGroup();
        String ieLockKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:{}:lock", (Object[])new Object[]{appName});
        while (true) {
            if (this.redisMutexService.tryLock(ieLockKey, TimeUnit.SECONDS, 10)) break;
            log.info("\u5e94\u7528{},\u6ca1\u6709\u83b7\u53d6\u4efb\u52a1\u64cd\u4f5c\u6743\u9650", (Object)appName);
        }
        log.info("\u5e94\u7528{},\u5df2\u83b7\u53d6\u4efb\u52a1\u64cd\u4f5c\u6743\u9650\uff0c\u53ef\u4ee5\u5f00\u59cb\u6267\u884c\u4efb\u52a1", (Object)appName);
        ValueOperations opsForValue = this.redisTemplate.opsForValue();
        String hostKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:{}:host", (Object[])new Object[]{appName});
        opsForValue.set((Object)hostKey, (Object)this.findServer());
        String lockKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:{}:serv", (Object[])new Object[]{appName});
        opsForValue.set((Object)lockKey, (Object)this.findServerInfo());
        this.importExportLoadTask.load(appName, true);
        ImportExportReloadTask task = (ImportExportReloadTask)this.applicationContext.getBean(ImportExportReloadTask.class);
        ThreadUtil.execAsync((Runnable)task, (boolean)true);
    }

    private String findServerInfo() {
        String hostName = "";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostName = addr.getHostName();
        }
        catch (UnknownHostException e1) {
            log.error("Error while getting host name", (Throwable)e1);
        }
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        String runtimeMxName = runtimeMXBean.getName();
        String osName = System.getProperty("os.name");
        String ip = IpUtil.getLocalIp();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String startTime = sdf.format(new Date(runtimeMXBean.getStartTime()));
        String serverInfo = String.format("IP:%s,\u4e3b\u673a\u540d:%s,OS:%s,\u5e94\u7528:%s,\u542f\u52a8\u65f6\u95f4:%s", ip, hostName, osName, runtimeMxName, startTime);
        return serverInfo;
    }

    private String findServer() {
        String ip = IpUtil.getPublicIp();
        if (StringUtils.isBlank((CharSequence)ip)) {
            log.error("\u672a\u83b7\u53d6\u5230\u672c\u673a\u7684\u516c\u7f51ip");
            LinkedHashSet strings = NetUtil.localIpv4s();
            Optional first = strings.stream().findFirst();
            if (first.isPresent()) {
                ip = (String)first.get();
            }
        }
        String server = CharSequenceUtil.format((CharSequence)"{}:{}{}", (Object[])new Object[]{ip, this.environment.getProperty("server.port"), this.environment.getProperty("server.servlet.context-path")});
        log.info(server);
        return server;
    }
}

