package com.biz.crm.common.ie.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.ImportExportTaskPoolService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import java.util.Map;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 导入导出任务线程池监控: task: 导入导出任务线程池监控(单节点使用)
 *
 * @author sunx
 * @date 2022/6/23
 */
@Api(tags = "导入导出任务线程池监控: task: 导入导出任务线程池监控")
@RestController
@RequestMapping(value = {"/v1/ie/task/pool"})
@Slf4j
public class ImportExportTaskPoolController {
  
  @Autowired
  private ImportExportTaskPoolService importExportTaskPoolService;
  @Autowired
  private ImportExportProperties      importExportProperties;
  
  /**
   * 加载任务,执行导出任务时
   *
   * @param poolName 线程池名字
   * @param taskCode 任务编码
   * @param ieType 导入导出类型
   * @return
   */
  @ApiOperation(value = "加载任务")
  @GetMapping(value = {"/reloadTask"})
  public Result<?> reloadTask(
      @RequestParam("poolName") String poolName,
      @RequestParam("taskCode") String taskCode,
      @RequestParam("ieType") String ieType) {
    // TODO XZK 加载任务，注意，该处导出任务执行，可能存在问题，请检查
    log.warn("加载任务，注意，该处导出任务执行，可能存在问题，请检查 reloadTask 方法中的导出处理逻辑setExportTaskDetailCode函数的处理");
    String appName = importExportProperties.getIeTaskGroup();
    this.importExportTaskPoolService.reloadTask(poolName, taskCode, ieType, appName);
    return Result.ok();
  }
  
  /**
   * 获取线程池名字
   *
   * @return
   */
  @ApiOperation(value = "获取线程池名字")
  @GetMapping(value = {"/findPoolNames"})
  public Result<Map<String, Set<String>>> findPoolNames() {
    return Result.ok(this.importExportTaskPoolService.findPoolNames());
  }
  
  /**
   * 获取线程池任务执行情况
   *
   * @return
   */
  @ApiOperation(value = "获取线程池任务执行情况")
  @GetMapping(value = {"/findDashboard"})
  public Result<Map<String, Object>> findDashboard(
      @RequestParam("name") String name, @RequestParam("ieType") String ieType) {
    final Map<String, Object> map = this.importExportTaskPoolService.findDashboard(name, ieType);
    return Result.ok(map);
  }
}
