package com.biz.crm.common.ie.local.controller;

import cn.hutool.core.text.CharSequenceUtil;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.config.ImportExportProperties;

import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.vo.ImportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.WebsocketServerModelVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.gateway.websocket.client.sdk.service.ChannelMsgService;

import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 导入导出websocket
 *
 * @author sunx
 * @date 2022/5/16 下午3:27
 */
@Slf4j
@RestController
@RequestMapping("/v1/ie/websocket")
public class WebsocketController {

  @Autowired(required = false)
  private RedisTemplate<String , Object> redisTemplate;
  @Autowired(required = false)
  private ImportExportProperties importExportProperties;
  @Autowired(required = false)
  private ChannelMsgService channelMsgService;
  
  @Value("${spring.application.name}")
  private String applicationName;
  /**
   * 导入导出模块中的导入信息
   */
  private static final String IE_IMPORT_MODEL_CODE = "ie_import_model";

  /**
   * 获取可用websocket服务
   *
   * @return
   */
  @ApiOperation("获取可用websocket服务")
  @GetMapping("/findServer")
  public Result<WebsocketServerModelVo> findServer() {
    try {
      final Object o =this.redisTemplate
          .opsForValue()
          .get(CharSequenceUtil.format(ImportExportConstant.IE_MAIN_HOST_PREFIX_FORMAT, this.importExportProperties.getIeTaskGroup()));
      Validate.notNull(o, "未获取到websocket服务信息");
      final WebsocketServerModelVo vo = new WebsocketServerModelVo();
      vo.setServer(CharSequenceUtil.format("ws://{}/ie/ws/ie", o.toString()));
      return Result.ok(vo);
    } catch (Exception e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 导入进度消息推送
   * @param vo 导入消息
   * @return
   */
  @PostMapping("/sendImportProcessMsg")
  public Result<?> sendImportProcessMsg(@RequestBody ImportProcessMsgVo vo) {
    try {
      byte[] jsonBytes = JSONObject.toJSONBytes(vo);
      String tenantCode = TenantUtils.getTenantCode();
      this.channelMsgService.sendByTenantCodeAndApplicationNameAndModelCode(tenantCode, applicationName, IE_IMPORT_MODEL_CODE, jsonBytes);
      return Result.ok();
    } catch (Exception e) {
      log.error("出错了{}", e.getMessage());
      return Result.error(e.getMessage());
    }
  }
}
