package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 导入模板明细(ImportTemplateDetail)实体类
 *
 * @author sunx
 * @since 2022-05-10 10:57:19
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_import_template_detail")
@Table(
    name = "ie_import_template_detail",
    indexes = {@Index(name = "ie_i_t_d_idx1", columnList = "template_code", unique = true)})
@ApiModel(value = "ImportTemplateDetail", description = "导入模板明细")
@org.hibernate.annotations.Table(appliesTo = "ie_import_template_detail", comment = "导入模板明细")
public class ImportTemplateDetail extends TenantEntity {
  private static final long serialVersionUID = 2007057536317003242L;

  /** 导入业务编码 */
  @ApiModelProperty("导入业务编码")
  @TableField(value = "business_code")
  @Column(name = "business_code", length = 64, columnDefinition = "varchar(64) COMMENT '导入业务编码'")
  private String businessCode;

  /** 模板编码 */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", length = 64, columnDefinition = "varchar(64) COMMENT '模板编码'")
  private String templateCode;

  /** 模板名称 */
  @ApiModelProperty("模板名称")
  @TableField(value = "template_name")
  @Column(name = "template_name", length = 64, columnDefinition = "varchar(64) COMMENT '模板名称'")
  private String templateName;

  /** 文件关联编码 */
  @ApiModelProperty("文件关联编码")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 255, columnDefinition = "varchar(255) COMMENT '文件关联编码'")
  private String fileCode;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;

  /** springboot应用程序名 */
  @ApiModelProperty("springboot应用程序名")
  @TableField(value = "application_name")
  @Column(
      name = "application_name",
      length = 64,
      columnDefinition = "varchar(64) COMMENT 'springboot应用程序名'")
  private String applicationName;

  /** 文件信息 */
  @ApiModelProperty("文件信息")
  @Transient
  @TableField(exist = false)
  private FileModelVo file;
}
