package com.biz.crm.common.ie.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.entity.ExportField;
import com.biz.crm.common.ie.local.repository.ExportFieldRepository;
import com.biz.crm.common.ie.sdk.dto.ExportFieldDto;
import com.biz.crm.common.ie.sdk.service.ExportFieldVoService;
import com.biz.crm.common.ie.sdk.vo.ExportFieldVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe: 导出字段（ExportField）表服务接口实现
 * @createTime 2023年07月25日 14:39:00
 */
@Service
public class ExportFieldVoServiceImpl implements ExportFieldVoService {

  @Autowired
  private ExportFieldRepository exportFieldRepository;

  @Autowired
  private LoginUserService loginUserService;


  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 根据菜单编码查询
   *
   * @param menuCode
   * @return
   */
  @Override
  public List<ExportFieldVo> findByMenuCode(String menuCode) {
    Validate.notBlank(menuCode, "菜单编码不能为空！");
    String tenantCode = TenantUtils.getTenantCode();
    String currentAccount = loginUserService.findCurrentAccount();
    List<ExportField> list = this.exportFieldRepository.findByMenuCode(tenantCode, currentAccount, menuCode);
    if (CollectionUtils.isEmpty(list)) {
      return new ArrayList<>();
    }
    return (List<ExportFieldVo>) this.nebulaToolkitService.copyCollectionByBlankList(list, ExportField.class, ExportFieldVo.class, HashSet.class, ArrayList.class);
  }

  /**
   * 保存字段  批量
   *
   * @param fieldList
   * @return
   */
  @Override
  public void save(List<ExportFieldDto> fieldList) {
    Validate.notEmpty(fieldList, "请选择需要导出的信息");
    String menuCode = this.validateAndGetMenuCode(fieldList);
    String currentAccount = loginUserService.findCurrentAccount();
    String tenantCode = TenantUtils.getTenantCode();
    //先删除再插入
    //目测更新频率快，直接物理删除，降低数据量。
    this.exportFieldRepository.deleteByMenuCode(tenantCode, currentAccount, menuCode);
    //插入
    List<ExportField> entity = (List<ExportField>) nebulaToolkitService.copyCollectionByBlankList(fieldList, ExportFieldDto.class, ExportField.class, HashSet.class, ArrayList.class);
    //按照前端传入的集合顺序确定排序
    for (int i = 0; i < entity.size(); i++) {
      ExportField exportField = entity.get(i);
      exportField.setFormOrder(i);
    }
    this.exportFieldRepository.saveBatch(entity);
  }

  /**
   * 新增校验及补充数据
   *
   * @param fieldList
   */
  private String validateAndGetMenuCode(List<ExportFieldDto> fieldList) {
    //集合里面只能是唯一一个菜单编码
    String menuCode = null;
    Set<String> menuCodeSet = fieldList.stream().map(ExportFieldDto::getMenuCode).collect(Collectors.toSet());
    Validate.isTrue(CollectionUtils.isNotEmpty(menuCodeSet) && menuCodeSet.size() == 1, "保存导出字段时，集合数据菜单编码不存在或者存在多个！");
    //取出菜单编码，用于返回
    menuCode = menuCodeSet.iterator().next();
    for (ExportFieldDto field : fieldList) {
      Validate.notNull(field, "请选择需要导出的信息");
      Validate.isTrue(StringUtils.isNoneBlank(field.getField(), field.getTitle(), field.getMenuCode()), "导出字段保存必填项校验失败，检查提交数据");
      String tenantCode = TenantUtils.getTenantCode();
      String currentAccount = loginUserService.findCurrentAccount();
      field.setAccount(currentAccount);
      field.setTenantCode(tenantCode);
    }
    return menuCode;
  }
}
