package com.biz.crm.common.ie.local.service.spring.rest;

import java.util.Map;
import org.springframework.core.MethodParameter;

/**
 * @title IMethodParameterTypeParse
 * @date 2023/10/9 11:49
 * @author Kevin
 * @description 方法参数类型校验和转换
 */
public interface IMethodParameterTypeParse<T> {

  /**
   * 参数校验
   * @param methodParameter
   * @return
   */
  public boolean supportsParameter(final MethodParameter methodParameter);

  /**
   * 参数处理
   * @param methodParameter
   * @param requestParamMap
   * @return
   * @throws IllegalArgumentException
   */
  public T resolveArgument(final MethodParameter methodParameter,final Map<String,Object> requestParamMap) throws IllegalArgumentException;
}
