package com.biz.crm.common.ie.local.service.task;

import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.config.ImportExportProperties.ExportProperties;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import cn.hutool.core.thread.ThreadUtil;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * 导出任务执行
 *
 * @author sunx
 * @date 2022/5/11
 */
@Component("_IeTaskExecutorForExport")
@Scope("prototype")
@Lazy
@Slf4j
public class IeTaskExecutorForExport implements Runnable, Comparable<IeTaskExecutorForExport> {
  /** 导入任务执行前置参数 */
  @Getter
  private IeExecutorVoForExport vo;
  /** 当前租户信息 */
  @Getter
  private AbstractTenantInfo tenantInfo;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired
  private ExportProcessService exportProcessService;
  @Autowired
  private ImportExportProperties importExportProperties;
  /** nebula security模块中，关于默认用户身份信息的配置情况 */
  @Autowired
  private SimpleSecurityProperties simpleSecurityProperties;

  public IeTaskExecutorForExport(IeExecutorVoForExport executorVo, AbstractTenantInfo tenantInfo) {
    this.vo = executorVo;
    this.tenantInfo = tenantInfo;
  }

  @Override
  public void run() {
    // 异步线程还原租户信息，切换数据源
    TenantContextHolder.setTenantInfo(tenantInfo);
    log.info("******导出任务开始执行中:{}", JSON.toJSONString(vo));
    Integer defaultLoginType = simpleSecurityProperties.getDefaultLoginType();
    try {
      TaskExecutorAuthTool.refreshUseAuthAndTenantCode(loginUserService, vo, defaultLoginType); // 重建用户权限环境
      this.exportProcessService.exportProcess(vo);
    } catch (Exception e) {
      log.error("执行导出操作异常：", e);
    }
    log.info("******导出任务执完成:{}", vo.getExportTaskDetailCode());
    long taskExecutionAfterSleep = importExportProperties.getTaskExecutionIntervalSleep();
    if (taskExecutionAfterSleep > 0) {
      ThreadUtil.sleep(taskExecutionAfterSleep);
      log.debug("******休眠释放数据库时间分片*********");
    }
  }

  @Override
  public int compareTo(IeTaskExecutorForExport other) {
    // 获取大任务参考值
    ExportProperties exportProperties = importExportProperties.getExportProperties();
    int bigTaskRowNum = exportProperties.getBigTaskRowNum();
    // 判断是否是大任务
    IeExecutorVoForExport myVo = this.getVo();
    IeExecutorVoForExport otherVo = other.getVo();
    int voCompare = Integer.compare(myVo.getTotal(), bigTaskRowNum);
    int otherCompare = Integer.compare(otherVo.getTotal(), bigTaskRowNum);
    // 比较两个任务，将小任务排序优先
    int compare = Integer.compare(voCompare, otherCompare);

    if (compare == 0) {
      // 两个任务同属于大任务或小任务，按照任务编号进行排序
      int compareTo = myVo.getTaskCode().compareTo(otherVo.getTaskCode());
      if (compareTo == 0) {
        compareTo = myVo.getExportTaskDetailCode().compareTo(otherVo.getExportTaskDetailCode());
      }
      return compareTo;
    } else {
      return compare;
    }
  }

}
