/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.biz.crm.common.ie.local.repository.ImportTemplateDetailRepository;
import com.biz.crm.common.ie.local.service.ImportTemplateDetailService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="importTemplateDetailService")
public class ImportTemplateDetailServiceImpl
implements ImportTemplateDetailService {
    @Autowired(required=false)
    private ImportTemplateDetailRepository importTemplateDetailRepository;
    @Autowired(required=false)
    private FileHandleService fileHandleService;

    @Override
    public List<ImportTemplateDetail> findDetailByBusinessCode(String businessCode) {
        if (StringUtils.isBlank((CharSequence)businessCode)) {
            return Lists.newLinkedList();
        }
        List<ImportTemplateDetail> list = this.importTemplateDetailRepository.findDetailByBusinessCode(businessCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newLinkedList();
        }
        Set<String> fileCodes = list.stream().map(ImportTemplateDetail::getFileCode).collect(Collectors.toSet());
        Map<String, FileModelVo> map = this.findFileModelVoMap(fileCodes);
        for (ImportTemplateDetail item : list) {
            item.setFile(map.get(item.getFileCode()));
        }
        return list;
    }

    @Override
    @Transactional
    public void createBatch(List<ImportTemplateDetail> list, String businessCode) {
        Validate.notEmpty((CharSequence)businessCode, (String)"\u4e1a\u52a1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.deleteByBusinessCodes(Lists.newArrayList((Object[])new String[]{businessCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int i = 1;
        HashSet codeSet = Sets.newHashSet();
        HashSet fileCodeSet = Sets.newHashSet();
        for (ImportTemplateDetail item : list) {
            item.setId(null);
            item.setBusinessCode(businessCode);
            item.setSort(i++);
            Validate.notEmpty((CharSequence)item.getTemplateCode(), (String)"\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notEmpty((CharSequence)item.getFileCode(), (String)"\u6a21\u677f\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.isTrue((boolean)codeSet.add(item.getTemplateCode()), (String)"\u5b58\u5728\u76f8\u540c\u7684\u6a21\u677f\u7f16\u7801", (Object[])new Object[0]);
            Validate.isTrue((boolean)fileCodeSet.add(item.getFileCode()), (String)"\u5b58\u5728\u76f8\u540c\u7684\u6a21\u677f\u6587\u4ef6", (Object[])new Object[0]);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.importTemplateDetailRepository.saveBatch(list);
    }

    @Override
    @Transactional
    public void deleteByBusinessCodes(List<String> businessCodes) {
        Validate.isTrue((!CollectionUtils.isEmpty(businessCodes) ? 1 : 0) != 0, (String)"\u4e1a\u52a1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.importTemplateDetailRepository.deleteByBusinessCodes(businessCodes);
    }

    private Map<String, FileModelVo> findFileModelVoMap(Set<String> fileCodeSet) {
        if (CollectionUtils.isEmpty(fileCodeSet)) {
            return Maps.newHashMap();
        }
        LinkedList uploadFileVos = Lists.newLinkedList();
        if (!CollectionUtils.isEmpty(fileCodeSet)) {
            for (String fileCode : fileCodeSet) {
                OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(fileCode);
                if (ordinaryFileVo == null) continue;
                uploadFileVos.add(ordinaryFileVo);
            }
        }
        if (CollectionUtils.isEmpty((Collection)uploadFileVos)) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        for (OrdinaryFileVo item : uploadFileVos) {
            FileModelVo modelVo = new FileModelVo();
            modelVo.setFileCode(item.getId());
            modelVo.setFileName(item.getOriginalFileName());
            map.put(item.getId(), modelVo);
        }
        return map;
    }
}

