/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.spring.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.service.spring.SpringControllerApiService;
import com.biz.crm.common.ie.local.service.spring.rest.IMethodParameterTypeParse;
import com.biz.crm.common.ie.local.service.spring.rest.ISpringApiResultParse;
import com.biz.crm.common.ie.local.service.spring.rest.strategy.ParamsParseFactory;
import com.bizunited.nebula.common.util.JsonUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Component
public class SpringControllerApiServiceImpl
implements SpringControllerApiService {
    private static final Logger log = LoggerFactory.getLogger(SpringControllerApiServiceImpl.class);
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Autowired
    private RequestMappingHandlerMapping requestMappingHandlerMapping;
    @Autowired
    private List<IMethodParameterTypeParse> iMethodParameterTypeParses;
    @Autowired
    private ParamsParseFactory paramsParseFactory;
    @Autowired
    private List<ISpringApiResultParse> iSpringApiResultParses;
    @Autowired
    private ApplicationContext applicationContext;

    @Override
    public Long getPageTotal(String url, String requestMapping, String requestParamJson) {
        int pageNum = 0;
        int pageSize = 1;
        IPage<?> page = this.getPage(url, requestMapping, requestParamJson, pageNum, pageSize);
        return page.getTotal();
    }

    @Override
    public IPage<?> getPage(String url, String requestMapping, String requestParamJson, int pageNum, int pageSize) {
        Object doInvoke = this.doInvokeByResult(url, requestMapping, requestParamJson, pageNum, pageSize);
        IPage<?> page = null;
        for (ISpringApiResultParse iSpringApiResultParse : this.iSpringApiResultParses) {
            if (!iSpringApiResultParse.isApplicable(doInvoke)) continue;
            page = iSpringApiResultParse.convertToPage(doInvoke);
            break;
        }
        Validate.isTrue((page != null ? 1 : 0) != 0, (String)"url\u5730\u5740\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u65e0\u5bf9\u5e94\u89e3\u6790\u7b56\u7565\u5b9e\u73b0\u7c7b(IDoInvokeResultParse) \u65e0\u6cd5\u89e3\u6790 %s", (Object[])new Object[]{url});
        return page;
    }

    private Object doInvokeByResult(String url, String requestMapping, String requestParamJson, int pageNum, int pageSize) {
        Validate.isTrue((pageNum >= 0 ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef\uff1apageNum \u5c0f\u4e8e 0", (Object[])new Object[0]);
        Validate.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"\u53c2\u6570\u9519\u8bef\uff1apageSize \u5c0f\u4e8e\u7b49\u4e8e 0", (Object[])new Object[0]);
        Map<String, Object> requestParamMap = new HashMap();
        try {
            requestParamMap = (Map)JSONObject.parseObject((String)requestParamJson, HashMap.class);
        }
        catch (JSONException jsonException) {
            log.warn("url[{}] \u7684\u8bf7\u6c42json\u65e0\u6cd5\u89e3\u6790\uff1a{}", (Object)url, (Object)requestParamJson);
        }
        requestParamMap.put("page", 1 + pageNum);
        requestParamMap.put("size", pageSize);
        requestParamMap.put("pageNum", 1 + pageNum);
        requestParamMap.put("pageSize", pageSize);
        Object doInvoke = this.doInvoke(url, requestMapping, requestParamMap);
        if (doInvoke instanceof Result) {
            Result result = (Result)doInvoke;
            return result.getResult();
        }
        log.warn("\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u975eResult\u5bf9\u8c61,{}", doInvoke);
        Validate.isTrue((boolean)(doInvoke instanceof Result), (String)"\u63a5\u53e3\u8fd4\u56de\u5bf9\u8c61\u975eResult\u5bf9\u8c61,{}", (Object[])new Object[]{doInvoke});
        return doInvoke;
    }

    @Override
    public Object doInvoke(String url, String requestMapping, Map<String, Object> requestParamMap) {
        HandlerMethod handlerMethod = this.getHandlerMethod(url, requestMapping);
        Validate.notNull((Object)handlerMethod, (String)"\u5f53\u524d\u7cfb\u7edf\u672a\u5339\u914d\u5230\u5bf9\u5e94\u7684url: %s", (Object[])new Object[]{url});
        Object[] args = this.getMethodArgumentValue(handlerMethod, requestParamMap);
        Object invoke = null;
        Method controllerMethod = handlerMethod.getMethod();
        Object controllerBean = handlerMethod.getBean();
        try {
            invoke = controllerMethod.invoke(controllerBean, args);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            log.error("\u76f4\u63a5\u8c03\u7528Api\u5f02\u5e38", (Throwable)exception);
            Validate.isTrue((boolean)false, (String)"\u76f4\u63a5\u8c03\u7528Api\u5f02\u5e38\uff0cURL%s\uff0c\u5f02\u5e38: %s", (Object[])new Object[]{url, exception.getCause()});
        }
        log.info("invoke:{}", invoke);
        return invoke;
    }

    private Object[] getMethodArgumentValue(HandlerMethod handlerMethod, Map<String, Object> requestParamMap) {
        MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
        Object[] args = new Object[methodParameters.length];
        for (int index = 0; index < args.length; ++index) {
            Object value;
            MethodParameter methodParameter = methodParameters[index];
            Class parameterType = methodParameter.getParameterType();
            Validate.isTrue((parameterType != HttpServletRequest.class ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301HttpServletRequest\u53c2\u6570 [%s]", (Object[])new Object[]{handlerMethod.getMethod()});
            for (IMethodParameterTypeParse iMethodParameterTypeParse : this.iMethodParameterTypeParses) {
                if (!iMethodParameterTypeParse.supportsParameter(methodParameter)) continue;
                args[index] = iMethodParameterTypeParse.resolveArgument(methodParameter, requestParamMap);
                break;
            }
            if (args[index] != null) continue;
            String parameterName = methodParameter.getParameterName();
            if (StringUtils.isNotBlank((CharSequence)parameterName) && (value = requestParamMap.get(parameterName)) != null) {
                args[index] = value.getClass() == parameterType ? value : this.paramsParseFactory.resolveArgument(parameterType, "" + value);
            }
            if (args[index] == null) {
                try {
                    args[index] = BeanUtil.toBeanIgnoreCase(requestParamMap, (Class)parameterType, (boolean)true);
                    args[index] = this.buildArgs(requestParamMap, parameterType, args[index]);
                }
                catch (Exception e) {
                    log.error("\u4e0d\u652f\u6301%s\u53c2\u6570\u7c7b\u578b [%s]", (Object)parameterType, (Object)handlerMethod.getMethod());
                    Validate.isTrue((boolean)false, (String)"\u4e0d\u652f\u6301%s\u53c2\u6570 [%s]", (Object[])new Object[]{parameterType, handlerMethod.getMethod()});
                }
            }
            log.info("param[{}] = {}", (Object)index, args[index]);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42\u53c2\u6570:{}", (Object)Arrays.toString(args));
        }
        return args;
    }

    private Object buildArgs(Map<String, Object> requestParamMap, Class<?> parameterType, Object obj) {
        Field[] declaredFields = parameterType.getDeclaredFields();
        JSONObject jsonObject = JsonUtils.toJSONObject((Object)obj);
        for (Field field : declaredFields) {
            DateTimeFormat annotation;
            String name = field.getName();
            Object o = requestParamMap.get(name);
            field.setAccessible(true);
            Class<?> type = field.getType();
            if (o == null || o.getClass() == type || jsonObject.get((Object)name) != null || !(o instanceof String) || type != Date.class || (annotation = field.getAnnotation(DateTimeFormat.class)) == null) continue;
            String pattern = annotation.pattern();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
            Date parse = null;
            try {
                parse = simpleDateFormat.parse(String.valueOf(o));
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u683c\u5f0f\u8f6c\u6362\u5f02\u5e38:");
                e.printStackTrace();
            }
            if (parse == null) continue;
            jsonObject.putIfAbsent((Object)name, (Object)parse);
        }
        return jsonObject.toJavaObject(parameterType);
    }

    private HandlerMethod getHandlerMethod(String url, String requestMapping) {
        String resolveLookUpPath = this.getPath(url);
        Map handlerMethods = this.requestMappingHandlerMapping.getHandlerMethods();
        HandlerMethod handlerMethod = null;
        block0: for (Map.Entry handlerMethodEntry : handlerMethods.entrySet()) {
            RequestMappingInfo requestMappingInfo = (RequestMappingInfo)handlerMethodEntry.getKey();
            HandlerMethod tempHandlerMethod = (HandlerMethod)handlerMethodEntry.getValue();
            Set directPaths = requestMappingInfo.getDirectPaths();
            if (!directPaths.contains(resolveLookUpPath)) continue;
            log.info("requestMappingInfo ===>{}", (Object)requestMappingInfo);
            RequestMethodsRequestCondition methodsCondition = requestMappingInfo.getMethodsCondition();
            Set methods = methodsCondition.getMethods();
            for (RequestMethod requestMethod : methods) {
                if (!requestMethod.name().equalsIgnoreCase(requestMapping)) continue;
                handlerMethod = tempHandlerMethod;
                handlerMethod = handlerMethod.createWithResolvedBean();
                continue block0;
            }
        }
        return handlerMethod;
    }

    private String getPath(String url) {
        String tempUrl = url.toLowerCase().startsWith("http") ? url : (url.startsWith("/") ? "http://127.0.0.1" + url : "http://127.0.0.1/" + url);
        String resolvedLookUpPath = null;
        try {
            URL urlObj = new URL(tempUrl);
            resolvedLookUpPath = urlObj.getPath();
        }
        catch (MalformedURLException e) {
            Validate.isTrue((boolean)false, (String)"URL\u8f6c\u6362\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff0c%s", (Object[])new Object[]{url});
        }
        if (resolvedLookUpPath.startsWith(this.contextPath)) {
            resolvedLookUpPath = resolvedLookUpPath.substring(this.contextPath.length());
        }
        return resolvedLookUpPath;
    }
}

