/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.thread.ThreadUtil;
import com.alibaba.fastjson.JSON;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.tools.TaskExecutorAuthTool;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVoForExport;
import com.bizunited.nebula.common.util.tenant.TenantContextHolder;
import com.bizunited.nebula.common.vo.AbstractTenantInfo;
import com.bizunited.nebula.security.sdk.config.SimpleSecurityProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="_IeTaskExecutorForExport")
@Scope(value="prototype")
@Lazy
public class IeTaskExecutorForExport
implements Runnable,
Comparable<IeTaskExecutorForExport> {
    private static final Logger log = LoggerFactory.getLogger(IeTaskExecutorForExport.class);
    private IeExecutorVoForExport vo;
    private AbstractTenantInfo tenantInfo;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private ExportProcessService exportProcessService;
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private SimpleSecurityProperties simpleSecurityProperties;

    public IeTaskExecutorForExport(IeExecutorVoForExport executorVo, AbstractTenantInfo tenantInfo) {
        this.vo = executorVo;
        this.tenantInfo = tenantInfo;
    }

    @Override
    public void run() {
        TenantContextHolder.setTenantInfo((AbstractTenantInfo)this.tenantInfo);
        log.info("******\u5bfc\u51fa\u4efb\u52a1\u5f00\u59cb\u6267\u884c\u4e2d:{}", (Object)JSON.toJSONString((Object)this.vo));
        Integer defaultLoginType = this.simpleSecurityProperties.getDefaultLoginType();
        try {
            TaskExecutorAuthTool.refreshUseAuthAndTenantCode(this.loginUserService, (IeExecutorVo)this.vo, defaultLoginType);
            this.exportProcessService.exportProcess(this.vo);
        }
        catch (Exception e) {
            log.error("\u6267\u884c\u5bfc\u51fa\u64cd\u4f5c\u5f02\u5e38\uff1a", (Throwable)e);
        }
        log.info("******\u5bfc\u51fa\u4efb\u52a1\u6267\u5b8c\u6210:{}", (Object)this.vo.getExportTaskDetailCode());
        long taskExecutionAfterSleep = this.importExportProperties.getTaskExecutionIntervalSleep();
        if (taskExecutionAfterSleep > 0L) {
            ThreadUtil.sleep((long)taskExecutionAfterSleep);
            log.debug("******\u4f11\u7720\u91ca\u653e\u6570\u636e\u5e93\u65f6\u95f4\u5206\u7247*********");
        }
    }

    @Override
    public int compareTo(IeTaskExecutorForExport other) {
        int otherCompare;
        ImportExportProperties.ExportProperties exportProperties = this.importExportProperties.getExportProperties();
        int bigTaskRowNum = exportProperties.getBigTaskRowNum();
        IeExecutorVoForExport myVo = this.getVo();
        IeExecutorVoForExport otherVo = other.getVo();
        int voCompare = Integer.compare(myVo.getTotal(), bigTaskRowNum);
        int compare = Integer.compare(voCompare, otherCompare = Integer.compare(otherVo.getTotal(), bigTaskRowNum));
        if (compare == 0) {
            int compareTo = myVo.getTaskCode().compareTo(otherVo.getTaskCode());
            if (compareTo == 0) {
                compareTo = myVo.getExportTaskDetailCode().compareTo(otherVo.getExportTaskDetailCode());
            }
            return compareTo;
        }
        return compare;
    }

    public IeExecutorVoForExport getVo() {
        return this.vo;
    }

    public AbstractTenantInfo getTenantInfo() {
        return this.tenantInfo;
    }
}

