package com.biz.crm.common.ie.local.context;

import lombok.AccessLevel;
import lombok.NoArgsConstructor;

/**
 * @author ning.zhang
 * @description 导出任务上下文信息操作类
 * @date 2025/05/14
 */
@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class ExportTaskContextHolder {

  private static final ThreadLocal<ExportTaskContext> TASK_CONTEXT = new ThreadLocal<>();

  public static void clearContext() {
    TASK_CONTEXT.remove();
  }

  public static ExportTaskContext getContext() {
    return TASK_CONTEXT.get();
  }

  public static void setContext(ExportTaskContext taskContext) {
    TASK_CONTEXT.set(taskContext);
  }
}
