package com.biz.crm.common.ie.local.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

/**
 * 导出任务关联文件(ExportTaskRFile)实体类
 *
 * @author sunx
 * @since 2022-05-20 14:13:47
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("ie_export_task_r_file")
@Table(name = "ie_export_task_r_file")
@ApiModel(value = "ExportTaskRFile", description = "导出任务关联文件")
@org.hibernate.annotations.Table(appliesTo = "ie_export_task_r_file", comment = "导出任务关联文件")
public class ExportTaskRelateFile extends UuidEntity {
  private static final long serialVersionUID = -2779972456031320641L;

  /** 任务编码 */
  @ApiModelProperty("任务编码")
  @TableField(value = "task_code")
  @Column(name = "task_code", length = 64, columnDefinition = "varchar(64) COMMENT '任务编码'")
  private String taskCode;

  /** 文件编码 */
  @ApiModelProperty("文件编码")
  @TableField(value = "file_code")
  @Column(name = "file_code", length = 255, columnDefinition = "varchar(255) COMMENT '文件编码'")
  private String fileCode;

  /** 排序 */
  @ApiModelProperty("排序")
  @TableField(value = "sort")
  @Column(name = "sort", length = 11, columnDefinition = "int(11) COMMENT '排序'")
  private Integer sort;

  /** 创建时间 */
  @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NOT_EMPTY)
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @Column(name = "create_time", length = 20, columnDefinition = "datetime COMMENT '创建时间 '")
  private Date createTime;

  /** 文件信息 */
  @ApiModelProperty("文件信息")
  @Transient
  @TableField(exist = false)
  private FileModelVo file;
}
