package com.biz.crm.common.ie.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.ie.local.entity.ExportTaskRelateFile;
import com.biz.crm.common.ie.local.mapper.ExportTaskRelateFileMapper;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 导出任务关联文件(repository)
 *
 * @author sunx
 * @date 2022-05-20 14:13:48
 */
@Component
public class ExportTaskRelateFileRepository
    extends ServiceImpl<ExportTaskRelateFileMapper, ExportTaskRelateFile> {

  /**
   * 根据任务编码删除管理的文件信息
   *
   * @param taskCode 任务编码
   */
  public void deleteByTaskCode(String taskCode) {
    LambdaQueryWrapper<ExportTaskRelateFile> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.in(ExportTaskRelateFile::getTaskCode, taskCode);
    this.baseMapper.delete(lambdaQuery);
  }

  /**
   * 根据任务编码获取文件信息
   *
   * @param taskCode 任务编码
   * @return
   */
  public List<ExportTaskRelateFile> findByTaskCode(String taskCode) {
    return this.lambdaQuery()
        .eq(ExportTaskRelateFile::getTaskCode, taskCode)
        .orderByAsc(ExportTaskRelateFile::getSort)
        .list();
  }
}
