package com.biz.crm.common.ie.local.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.model.dto.ExportTaskConditionModelDto;
import com.biz.crm.common.ie.sdk.excel.process.AbstractEsParagraphExportProcess;
import com.biz.crm.common.ie.sdk.utils.IeJsonUtils;
import com.biz.crm.common.ie.sdk.utils.WebApiParamsTools;
import com.biz.crm.common.ie.sdk.vo.EsParagraphFieldRangeVo;
import com.bizunited.nebula.common.register.ElasticsearchQueryRegister;
import com.bizunited.nebula.common.service.es.ElasticsearchQueryService;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.bean.ExportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.entity.ExportTaskDetail;
import com.biz.crm.common.ie.local.entity.ExportTaskRelateFile;
import com.biz.crm.common.ie.local.model.dto.ExportTaskModelDto;
import com.biz.crm.common.ie.local.model.dto.ExportTaskProcessModelDto;
import com.biz.crm.common.ie.local.model.vo.FileModelVo;
import com.biz.crm.common.ie.local.repository.ExportTaskDetailRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRelateFileRepository;
import com.biz.crm.common.ie.local.repository.ExportTaskRepository;
import com.biz.crm.common.ie.local.service.ExportTaskDetailService;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.dto.CreateExportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExportProcessEnum;
import com.biz.crm.common.ie.sdk.event.ImportExportTaskEventListener;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.service.ExportProcessService;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.europa.database.sdk.context.execute.DatabaseExecuteExternalRequest;
import com.bizunited.nebula.europa.sdk.context.execute.RequestParameter;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.json.JSONUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

/**
 * 导出任务(ExportTask)表服务实现类
 *
 * @author sunx
 * @date 2022-05-18 16:31:05
 */
@Service("exportTaskService")
@Slf4j
public class ExportTaskServiceImpl implements ExportTaskService {
  
  @Autowired(required = false)
  private ExportTaskRepository exportTaskRepository;
  
  @Autowired(required = false)
  private ExportTaskRelateFileRepository exportTaskRelateFileRepository;
  
  @Autowired(required = false)
  private ExportTaskDetailService exportTaskDetailService;
  
  @Autowired(required = false)
  private GenerateCodeService generateCodeService;
  
  @Autowired(required = false)
  private ImportExportProperties importExportProperties;
  
  @Autowired(required = false)
  private FileHandleService fileHandleService;
  
  @Autowired(required = false)
  private ExportTaskDetailRepository exportTaskDetailRepository;

  @Autowired(required = false)
  private ExportSendProcessMsgBean exportSendProcessMsgBean;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private List<ImportExportTaskEventListener> importExportTaskAuthRecordListeners;
  private static final String                 EUROPA_CODE_PARAMETER_NAME = "europaInfoCode";

  @Autowired
  private ExportProcessService exportProcessService;

  @Value("${server.servlet.context-path}")
  private String contextPath;

  @Autowired
  private RequestMappingHandlerMapping requestMappingHandlerMapping;
  @Autowired
  private ElasticsearchQueryService elasticsearchQueryService;

  @Override
  public Page<ExportTask> findByConditions(Pageable pageable, ExportTaskPaginationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    dto      = Optional.ofNullable(dto).orElse(new ExportTaskPaginationDto());
    dto.setApplicationName(this.importExportProperties.getIeTaskGroup());
    dto.setAppCode(TenantUtils.getTenantCode());
    dto.setTenantCode(TenantUtils.getTenantCode());
    Page<ExportTask> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    final Page<ExportTask> result = this.exportTaskRepository.findByConditions(page, dto);
    
    if (Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())) {
      Set<String> taskCodeSet =
          result.getRecords().stream().map(ExportTask::getTaskCode).collect(Collectors.toSet());
      List<ExportTaskDetail> list = this.exportTaskDetailService.findByTaskCodes(taskCodeSet);
      if (!CollectionUtils.isEmpty(list)) {
        Map<String, List<ExportTaskDetail>> map =
            list.stream().collect(Collectors.groupingBy(ExportTaskDetail::getTaskCode));
        for (ExportTask item : result.getRecords()) {
          item.setList(map.get(item.getTaskCode()));
        }
      }
    }
    return result;
  }

  /**
   * 导出文件管理-取消导出任务
   *
   * @param codes
   */
  @Override
  public void cancelTask(List<String> codes) {
    Validate.isTrue(ObjectUtils.isNotEmpty(codes), "请选择预取消的任务");
    String applicationName = this.importExportProperties.getIeTaskGroup();
    String tenantCode = TenantUtils.getTenantCode();
    List<String> list = new ArrayList<>();
    list.add(ExecStatusEnum.DEFAULT.getDictCode());
    list.add(ExecStatusEnum.RUNNING.getDictCode());
    codes.forEach(k -> {
      //更新主表的执行状态 前提是 待执行和执行中的生效
      this.exportTaskRepository.lambdaUpdate()
              .set(ExportTask::getExecStatus, ExecStatusEnum.CANCEL.getDictCode())
              .eq(ExportTask::getApplicationName, applicationName)
              .eq(ExportTask::getAppCode, tenantCode)
              .eq(ExportTask::getTenantCode, tenantCode)
              .eq(ExportTask::getTaskCode, k)
              .in(ExportTask::getExecStatus, list)
              .update();
      this.exportTaskDetailRepository.lambdaUpdate()
              .set(ExportTaskDetail::getExecStatus, ExecStatusEnum.CANCEL.getDictCode())
              .eq(ExportTaskDetail::getApplicationName, applicationName)
              .eq(ExportTaskDetail::getAppCode, tenantCode)
              .eq(ExportTaskDetail::getTenantCode, tenantCode)
              .eq(ExportTaskDetail::getTaskCode, k)
              .in(ExportTaskDetail::getExecStatus, list)
              .update();
    });
  }

  @Override
  public ExportTask findDetailByTaskCode(String taskCode) {
    if (StringUtils.isBlank(taskCode)) {
      return null;
    }
    ExportTask exportTask = this.findExportTask(taskCode);
    if (Objects.isNull(exportTask)) {
      return null;
    }
    final List<ExportTaskDetail> detailList =
        this.exportTaskDetailService.findByTaskCodes(Sets.newHashSet(exportTask.getTaskCode()));
    if (!CollectionUtils.isEmpty(detailList)) {
      for (ExportTaskDetail detail : detailList) {
        if (StringUtils.isNotBlank(detail.getFileCode())) {
          OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(detail.getFileCode());
          if (ordinaryFileVo == null) {
            continue;
          }
          FileModelVo fileModelVo = new FileModelVo();
          fileModelVo.setFileCode(ordinaryFileVo.getId());
          fileModelVo.setFileName(ordinaryFileVo.getOriginalFileName());
          detail.setFile(fileModelVo);
        }
      }
    }
    final List<ExportTaskRelateFile> fileList =
        this.exportTaskRelateFileRepository.findByTaskCode(taskCode);
    if (!CollectionUtils.isEmpty(fileList)) {
      for (ExportTaskRelateFile relateFile : fileList) {
        if (StringUtils.isNotBlank(relateFile.getFileCode())) {
          OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(relateFile.getFileCode());
          if (ordinaryFileVo == null) {
            continue;
          }
          FileModelVo fileModelVo = new FileModelVo();
          fileModelVo.setFileCode(ordinaryFileVo.getId());
          fileModelVo.setFileName(ordinaryFileVo.getOriginalFileName());
          relateFile.setFile(fileModelVo);
        }
      }
    }
    
    if (!CollectionUtils.isEmpty(detailList)) {
      exportTask.setList(detailList);
    }
    
    if (!CollectionUtils.isEmpty(fileList)) {
      exportTask.setFileList(fileList);
    }
    return exportTask;
  }

  @Override
  public ExportTask findExportTask(String taskCode) {
    return this.exportTaskRepository.findByTaskCode(taskCode);
  }
  /**
   * 创建任务，并根据执行器确定是否直接获取总数
   * @see ExportTaskDetailService#saveExportTaskAndCreateExportTaskDetail(ExportTask)
   */
  @Override
  @Transactional
  public ExportTask create(CreateExportTaskDto dto) {
    // 获取和这个导出请求匹配的导出任务处理器（二开开发团队可自行注册的处理器）
    // 获取和这个导出请求匹配的导出任务处理器（二开开发团队可自行注册的处理器）
    //1.验证url是否有效
    this.validateUrlAndParams(dto);
    final String businessCode = dto.getBusinessCode();
    final ExportProcess<?> exportProcess = this.exportProcessService.findExportProcess(businessCode);
    Validate.notNull(exportProcess, "未获取到对应的业务处理器");
    final Integer excelMaxCount = this.importExportProperties.getExportProperties().getExcelMaxCount();
    Validate.isTrue(excelMaxCount >= exportProcess.getPageSize(), "导出处理器pageSize设置必须小于导出配置的最大导出数量设置");
    
    // step02: 构建MarsAuthorityContext过滤器,对数据权限进行过滤
    // 不止要属性当前执行线程的用户身份上下文，还要根据可能的marscodelist，设置数据权限上下文
    MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
    
    Validate.notNull(dto, "创建导出任务参数不能为空");
    ExportTask exportTask = convertExportTaskObj(dto);
    this.validation(exportTask, exportProcess); // 验证数据，补充数据
    this.validateExecutingTask(exportTask);// 校验是否有进行中的任务
    if (false == exportProcess.isAsyncGetTotal()) { // 非异步获取任务总数（默认）
      // 改为方法调用[调用方法内部会保存：exportTask]
      // 保证后续消息推送正确推送到人的身上
      exportTask.setCreateAccount(this.loginUserService.findCurrentAccount());
      List<ExportTaskDetail> exportTaskDetail = this.exportTaskDetailService.saveExportTaskAndCreateExportTaskDetail(exportTask);
      log.debug("总记录数{}，拆分任务{}", exportTask.getTotal(), exportTaskDetail.size());
    } else {// 异步任务保存
      this.exportTaskRepository.saveOrUpdate(exportTask);
      log.info("BusinessCode={},任务{}异步获取数据", dto.getBusinessCode(), exportTask.getTaskCode());
      final String taskCode = exportTask.getTaskCode();
      final String createAccount = exportTask.getCreateAccount();
      this.exportSendProcessMsgBean.sendTaskProcessMsg(taskCode, ExecStatusEnum.RUNNING.getDictCode(),
          ExportProcessEnum.ASYNC_GET_TOTAL, createAccount, true);
    }
    marsAuthorityContext = MarsAuthorityContextHolder.getContext();
    return exportTask;
  }

  /**
   * 校验是否有进行中的任务
   *
   * @param exportTask 导出任务
   */
  private void validateExecutingTask(ExportTask exportTask) {
    ExportTaskConditionModelDto conditionModelDto = new ExportTaskConditionModelDto();
    conditionModelDto.setApplicationName(this.importExportProperties.getIeTaskGroup());
    conditionModelDto.setAppCode(TenantUtils.getTenantCode());
    conditionModelDto.setTenantCode(TenantUtils.getTenantCode());
    conditionModelDto.setBusinessCode(exportTask.getBusinessCode());
    conditionModelDto.setParentCode(exportTask.getParentCode());
    conditionModelDto.setFunctionCode(exportTask.getFunctionCode());
    conditionModelDto.setCreateAccount(this.loginUserService.findCurrentAccount());
    conditionModelDto.setExecStatusSet(Sets.newHashSet(ExecStatusEnum.RUNNING.getDictCode()
        , ExecStatusEnum.DEFAULT.getDictCode(), ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode()));
    List<ExportTask> exportTasks = this.exportTaskRepository.findByExportTaskConditionModelDto(
        conditionModelDto);
    Validate.isTrue(CollectionUtils.isEmpty(exportTasks), "当前页面有进行中的导出任务，请到文件中心查看！");
  }

  /**
   * 验证url是否有效 接口入参和出参是否符合要求
   * @param dto
   */
  private void validateUrlAndParams(CreateExportTaskDto dto) {
    String businessCode = dto.getBusinessCode();
    if (!ImportExportConstant.EXPORT_BIZ_CODE_EXPORT_WEB_API.equals(businessCode)) {
      return;
    } else {
      //1.验证url地址是否有效
      String url = dto.getWebApiUrl();
      Validate.notNull(url, "webApi导出时，请求地址url不能为空！");
      Map<String, Object> params = dto.getParams();
      String requestMapping = (String) params.get(WebApiParamsTools.REQUEST_MAPPING);
      HandlerMethod handlerMethod = this.getHandlerMethod(url, requestMapping);
      Validate.notNull(handlerMethod, "当前系统未匹配到对应的url: %s", url);
      //2.验证方法入参是否满足条件
      MethodParameter[] methodParameters = handlerMethod.getMethodParameters();
      int count = 0;
      for (MethodParameter methodParameter : methodParameters) {
        Class<?> parameterType = methodParameter.getParameterType();
        if (parameterType == Pageable.class) {
          count++;
        }
      }
      Validate.isTrue(count > 0, "请求接口方法入参未包含pageable对象！");
      //3.验证返回值是否满足条件
      Type returnType = handlerMethod.getMethod().getReturnType();
      Validate.isTrue(returnType == Result.class, "接口返回值类型不符合标准 :{}", returnType);
    }
  }
  /**
   * 请求 url 地址获取handlerMethod 的方法 校验请求方法是否是服务器内部因存在的api方法
   * @param url
   * @param requestMapping
   * @return
   */
  private HandlerMethod getHandlerMethod(String url, String requestMapping) {
    //1.判断路径是否有效
    final String resolveLookUpPath = this.getPath(url);
    //2.处理器映射器 获取处理方法
    Map<RequestMappingInfo, HandlerMethod> handlerMethods = requestMappingHandlerMapping.getHandlerMethods();
    HandlerMethod handlerMethod = null;
    for (Map.Entry<RequestMappingInfo,HandlerMethod> handlerMethodEntry : handlerMethods.entrySet()){
      //请求映射信息
      final RequestMappingInfo requestMappingInfo = handlerMethodEntry.getKey();
      //处理器方法
      final HandlerMethod tempHandlerMethod = handlerMethodEntry.getValue();
      //获取请求映射信息中 获取定向（指向） 路径
      final Set<String> directPaths = requestMappingInfo.getDirectPaths();
      if (directPaths.contains(resolveLookUpPath)){
        log.info("requestMappingInfo ===>{}",requestMappingInfo);
        //从请求映射信息中获取方法详情
        final RequestMethodsRequestCondition methodsCondition = requestMappingInfo.getMethodsCondition();
        //获取方法集
        Set<RequestMethod> methods = methodsCondition.getMethods();
        for (RequestMethod requestMethod : methods){
          if (requestMethod.name().equalsIgnoreCase(requestMapping.toUpperCase())){
              handlerMethod = tempHandlerMethod;
              handlerMethod = handlerMethod.createWithResolvedBean();
              break;
          }
        }
      }
    }
    return handlerMethod;
  }


  /**
   * 判断请求url地址是否有效 并返回
   * @param url
   * @return
   */
  private String getPath(String url) {
    String tempUrl;
    //1.构建完整的url地址
    //将url地址转换为小写  判断是否以http开头
    if (url.toLowerCase().startsWith("http")){
      tempUrl = url;
    }else {
      if (url.startsWith("/")){
        tempUrl = "http://127.0.0.1" + url;
      }else {
        tempUrl = "http://127.0.0.1/" + url;
      }
    }
    //2.地址中涉及特殊字符，如 '|' '&' 等，所以不能直接用string 代替  URI 来访问
    String resolvedLookUpPath = null;
    try {
      URL urlObj = new URL(tempUrl);
      resolvedLookUpPath = urlObj.getPath();
    }catch (MalformedURLException e){
      Validate.isTrue(false,"URL转换失败，请检查，%s",url);
    }
    //判断访问路径中是否以服务路径开头 例如/crm-mdm/...
    if (resolvedLookUpPath.startsWith(contextPath)){
      //去掉服务路径
      resolvedLookUpPath = resolvedLookUpPath.substring(contextPath.length());
    }
    return resolvedLookUpPath;
  }

  /**
   * 讲前端请求的对象转换为导出任务对象
   * 
   * @param dto
   * @return
   */
  private ExportTask convertExportTaskObj(CreateExportTaskDto dto) {
    Map<String, Object> params = dto.getParams();
    if (params != null && !params.isEmpty()) {
      boolean isEuropaForm = params.containsKey(EUROPA_CODE_PARAMETER_NAME);
      // xzk 测试代码:设置全部表单从europa出结果
      if (isEuropaForm == true) {
        dto.setIsEuropa(isEuropaForm);
        String europaInfoCode = "" + params.get(EUROPA_CODE_PARAMETER_NAME);
        dto.setEuropaInfoCode(europaInfoCode);
        // #########################################
      }
    }
    
    Validate.notBlank(dto.getBusinessCode(), "导出业务编码错误，请检查！");
    
    ExportTask exportTask = new ExportTask();
    // 初始化参数
    exportTask.setBusinessCode(dto.getBusinessCode());
    exportTask.setTaskSource(dto.getTaskSource());
    // 为导出请求设定可能的数据权限控住编号（mars_list_code）
    exportTask.setMarsListCode(StringUtils.isNotBlank(dto.getMarsListCode()) ? dto.getMarsListCode() : null);
    exportTask.setFunctionCode(StringUtils.isNotBlank(dto.getFunctionCode()) ? dto.getFunctionCode() : null);
    exportTask.setParentCode(StringUtils.isNotBlank(dto.getParentCode()) ? dto.getParentCode() : null);
    if (params != null && !params.isEmpty()) {
      String jsonStr = JSONUtil.toJsonStr(params);
      exportTask.setParametersJson(jsonStr);
    }
    // 为导出请求设定导出任务（关联存储其导出任务的编号）
    String taskCode = this.generateCodeService.generateCodeString(ImportExportConstant.EXPORT_TASK_CODE_PREFIX);
    exportTask.setTaskCode(taskCode);
    exportTask.setWebApiUrl(dto.getWebApiUrl());
    return exportTask;
  }

  /**
   *
   * @param europaInfoCode
   * @param params 请求参数
   * @return
   */
  private RequestParameter convertRequestParameter(String europaInfoCode, Map<String, Object> params) {
    // {position_name_1664185318683=纳美大区, size=15, pageSize=15, sort=create_time,desc, page=0,
    // europaInfoCode=mdm_position_dataview_1664185318636, sort.create_time=desc, pageNum=1}
    DatabaseExecuteExternalRequest requestParameter = new DatabaseExecuteExternalRequest();
    // 组装查询参数
    requestParameter.setAttribute("europaInfoCode", europaInfoCode);
    requestParameter.setPageable(PageRequest.of(0, 60000));
    // 将请求参数引入
    params.forEach((key, value) -> {
      requestParameter.setAttribute(key, value);
    });
    String jsonStr = JSONUtil.toJsonStr(requestParameter);
    System.out.println(jsonStr);
    // invokeParamContent.setAttribute(parameterName, value);
    return requestParameter;
  }

  /**
   * 构建Europa请求参数
   *
   * @param jsonParam
   * @return
   */
  private RequestParameter buildRequestParameter(String jsonParam) {
    DatabaseExecuteExternalRequest invokeParamContent = new DatabaseExecuteExternalRequest();
    // 开始逐个记录json中的顶级属性
    if (StringUtils.isNotBlank(jsonParam)) {
      JSONObject bodyJson = JSONObject.parseObject(jsonParam);
      Object object = bodyJson.get("params");
      if ((object != null) && (object instanceof JSONObject)) {
        JSONObject params = (JSONObject) object;
        for (Entry<String, Object> entry : params.entrySet()) {
          if (!(entry.getValue() instanceof JSON)) {
            invokeParamContent.setAttribute(entry.getKey(), entry.getValue());
          }
        }
      }

      Set<Map.Entry<String, Object>> jsonItems = bodyJson.entrySet();

      for (Map.Entry<String, Object> jsonItem : jsonItems) {
        String key = jsonItem.getKey();
        Object value = jsonItem.getValue();
        // 只记录一级信息
        if (!(value instanceof JSON)) {
          invokeParamContent.setAttribute(key, value);
        }
      }
    }
    invokeParamContent.setPageable(PageRequest.of(0, 60000));
    return invokeParamContent;
  }


  @SuppressWarnings("unchecked")
  @Override
  public ExportTaskProcessVo findExportTaskModelVoByDetailCode(String detailCode) {
    ExportTaskDetail detail = this.exportTaskDetailService.findByDetailCode(detailCode);
    if (Objects.isNull(detail)) {
      return null;
    }
    ExportTask task = this.exportTaskRepository.findByTaskCode(detail.getTaskCode());
    if (Objects.isNull(task)) {
      return null;
    }
    final ExportTaskProcessVo vo = new ExportTaskProcessVo();
    vo.setAppCode(task.getAppCode());
    vo.setApplicationName(task.getApplicationName());
    vo.setBusinessCode(task.getBusinessCode());
    vo.setCreateAccount(task.getCreateAccount());
    vo.setCreateAccountName(task.getCreateName());
    vo.setDetailCode(detail.getDetailCode());
    vo.setExecStatus(detail.getExecStatus());
    vo.setPageNo(detail.getPageNo());
    vo.setTotal(task.getTotal());
    vo.setPageSize(detail.getPageSize());
    vo.setParametersJson(task.getParametersJson());
    vo.setTaskCode(task.getTaskCode());
    vo.setTenantCode(task.getTenantCode());
    vo.setMarsListCode(task.getMarsListCode());
    vo.setFunctionCode(task.getFunctionCode());
    vo.setParentCode(task.getParentCode());
    vo.setWebApiUrl(task.getWebApiUrl());
    if (StringUtils.isNotBlank(detail.getParagraphRanges())) {
      List<List<EsParagraphFieldRangeVo>> fieldRanges = JSONArray.parseArray(detail.getParagraphRanges(), List.class).stream()
          .map(list-> (List<EsParagraphFieldRangeVo>) list.stream()
              .map(object -> JSON.parseObject(JSON.toJSONString(object), EsParagraphFieldRangeVo.class))
              .collect(Collectors.toList()))
          .collect(Collectors.toList());
      vo.setTotalParagraphFieldRanges(fieldRanges);
    }
    return vo;
  }
  
  @Override
  @Transactional
  public void updateExecStatus(ExportTaskProcessModelDto dto) {
    Validate.notNull(dto, "变更参数不能为空");
    Validate.isTrue(
        StringUtils.isNoneBlank(dto.getTaskCode(), dto.getExecStatus()), "任务编码、执行状态不能为空");
    this.exportTaskRepository.updateByExportTaskProcessModelDto(dto);
  }
  
  @Override
  @Transactional
  public void updateByExportTaskProcessModelDto(ExportTaskProcessModelDto dto) {
    this.updateExecStatus(dto);
    this.exportTaskRelateFileRepository.deleteByTaskCode(dto.getTaskCode());
    Date now = new Date();
    if (!CollectionUtils.isEmpty(dto.getFileCodeSet())) {
      int i = 0;
      List<ExportTaskRelateFile> list = Lists.newArrayList();
      for (String item : dto.getFileCodeSet()) {
        final ExportTaskRelateFile cur = new ExportTaskRelateFile();
        cur.setFileCode(item);
        cur.setSort(i++);
        cur.setTaskCode(dto.getTaskCode());
        cur.setCreateTime(now);
        list.add(cur);
      }
      this.exportTaskRelateFileRepository.saveBatch(list);
    }
  }
  
  /**
   * 任务拆分
   *
   * @param exportTask
   * @param total
   * @param pageSize 一个sheet
   * @return
   */
  private List<ExportTaskDetail> findDetail(ExportTask exportTask, Integer total, Integer pageSize) {
    Validate.isTrue(pageSize.compareTo(0) > 0, "处理器子任务拆分size需大于0");
    List<ExportTaskDetail> list = Lists.newArrayList();
    // 整除的时候需要减1,防止多出来一个分页
    final Integer page = total % pageSize == 0 ? total / pageSize - 1 : total / pageSize;
    final Integer lastPageSize = total % pageSize == 0 ? pageSize : total % pageSize;
    for (int i = 0; i <= page; i++) {
      final ExportTaskDetail cur = new ExportTaskDetail();
      cur.setPageSize((i == page) ? lastPageSize : pageSize);// 最后一页实际剩余页数，否则就是最大条数
      cur.setPageNo(i);
      cur.setTaskCode(exportTask.getTaskCode());
      cur.setAppCode(exportTask.getAppCode());
      cur.setApplicationName(exportTask.getApplicationName());
      cur.setDetailCode(exportTask.getTaskCode() + "_" + cur.getPageNo());
      cur.setMarsListCode(exportTask.getMarsListCode());
      list.add(cur);
    }
    return list;
  }

  /**
   * 获取处理参数
   *
   * @param exportProcess
   * @param dto
   * @return
   */
  private Map<String, Object> findParams(ExportProcess exportProcess, CreateExportTaskDto dto) {
    if (Objects.isNull(exportProcess)) {
      return Maps.newHashMap();
    }
    Map<String, Object> map = exportProcess.getGlobalParams();
    if (map == null) {
      map = Maps.newHashMap();
    }
    if (dto.getParams() != null && !dto.getParams().isEmpty()) {
      for (Entry<String, Object> item : dto.getParams().entrySet()) {
        map.put(item.getKey(), item.getValue());
      }
    }
    return map;
  }

  private void validation(ExportTask exportTask, ExportProcess<?> exportProcess) {
    Validate.notNull(exportTask, "导出任务创建参数不能为空");
    Validate.notBlank(exportTask.getBusinessCode(), "导出业务编码不能为空");
    exportTask.setTaskName(exportProcess.getBusinessName());
    
    // 如果需要初始化，则状态为NEED_EXPORT_TASK_DETAIL，否则为DEFAULT
    exportTask.setExecStatus(exportProcess.isAsyncGetTotal() ? ExecStatusEnum.NEED_EXPORT_TASK_DETAIL.getDictCode()
        : ExecStatusEnum.DEFAULT.getDictCode());

    exportTask.setTenantCode(TenantUtils.getTenantCode());
    exportTask.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
    exportTask.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    exportTask.setApplicationName(this.importExportProperties.getIeTaskGroup());
    exportTask.setAppCode(TenantUtils.getTenantCode());
    exportTask.setAsyncGetTotal(exportProcess.isAsyncGetTotal());
    // 202211修正文件名--begin
    ExportTaskProcessVo task = nebulaToolkitService.copyObjectByWhiteList(exportTask, ExportTaskProcessVo.class, HashSet.class, ArrayList.class);
    String fileName = null;
    String fileTempName = exportProcess.getTaskFileName(task);
    if(StringUtils.isNotBlank(fileTempName)){
      fileName = CharSequenceUtil.format("{}_{}{}", fileTempName, 0, ImportExportConstant.IE_FILE_SUFFIX);
    } else {
      fileName = CharSequenceUtil.format("主文件_{}_{}_{}{}", task.getTaskSource(), exportTask.getTaskCode(), 0, ImportExportConstant.IE_FILE_SUFFIX);
    }
    exportTask.setFileName(fileName);
  }

  @Override
  public int getTaskCountByNoExe(ExportTask current) {
    return this.exportTaskRepository.getTaskCountByNoExe(current);
  }

  @Override
  public void updateExecStatus(String applicationName, ExecStatusEnum running, String... taskIdArray) {
    List<ExportTask> entityList= new ArrayList<>();
    for ( String id: taskIdArray) {
      ExportTask exportTask = new ExportTask();
      exportTask.setId(id);
      exportTask.setExecStatus(running.getDictCode());
      entityList.add(exportTask);
    }
    this.exportTaskRepository.saveOrUpdateBatch(entityList);
  }

  @Override
  @Transactional
  public void updateExecStatusContainsDetail(ExecStatusEnum execStatusEnum, Set<String> taskCodes) {
    this.exportTaskRepository.updateExecStatusByTaskCodes(execStatusEnum, taskCodes);
    this.exportTaskDetailRepository.updateExecStatusByTaskCodes(execStatusEnum, taskCodes);
  }

  @Override
  public List<ExportTask> findExportTaskNoGetTotal(ExportTaskModelDto dto) {
    if (Objects.isNull(dto)) {
      return Lists.newLinkedList();
    }
    log.debug("读取一天内的没有获取总数的任务");
    return this.exportTaskRepository.findExportTaskNoGetTotal(dto);
  }

  @Override
  public List<ExportTask> findExportTaskNoEsParagraph(ExportTaskModelDto dto) {
    if (Objects.isNull(dto)) {
      return Lists.newLinkedList();
    }
    ExportTaskConditionModelDto modelDto = new ExportTaskConditionModelDto();
    modelDto.setExecStatusSet(dto.getExecStatusSet());
    modelDto.setApplicationName(dto.getApplicationName());
    return this.exportTaskRepository.findByExportTaskConditionModelDto(modelDto);
  }

  @Override
  @Transactional
  public void execExportGetTotal(ExportTask exportTask) {
    List<ExportTaskDetail> exportTaskDetails =
        this.exportTaskDetailService.saveExportTaskAndCreateExportTaskDetail(exportTask);
    final ExportProcess<?> exportProcess = this.exportProcessService.findExportProcess(exportTask.getBusinessCode());
    exportTask.setList(exportTaskDetails);
    ExecStatusEnum execStatus = ExecStatusEnum.DEFAULT;
    // 如果是es的大数据分段导出,执需要将状态修改为待分段,以便后续分段操作
    if (exportProcess instanceof AbstractEsParagraphExportProcess) {
      execStatus = ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL;
    }
    this.updateExecStatus(exportTask.getApplicationName(), execStatus, exportTask.getId());
  }

  @Override
  public void execExportEsParagraph(ExportTask exportTask) {
    this.exportSendProcessMsgBean.sendTaskProcessMsg(exportTask.getTaskCode(), ExecStatusEnum.NEED_PARAGRAPH_EXPORT_TASK_DETAIL.getDictCode(),
        ExportProcessEnum.ASYNC_ES_PARAGRAPH, exportTask.getCreateAccount(), true);
    List<ExportTaskDetail> taskDetails = this.exportTaskDetailService.findByTaskCodes(Sets.newHashSet(exportTask.getTaskCode()));
    taskDetails.sort(Comparator.comparing(ExportTaskDetail::getPageNo));
    List<EsParagraphFieldRangeVo> lastFieldRanges = Lists.newArrayList();
    for (ExportTaskDetail exportTaskDetail : taskDetails) {
      lastFieldRanges = this.exportTaskDetailService.execExportTaskDetailEsParagraph(exportTask, exportTaskDetail, lastFieldRanges);
    }
    this.updateExecStatus(exportTask.getApplicationName(), ExecStatusEnum.DEFAULT, exportTask.getId());
  }
}
