package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IMethodParameterTypeParse;
import com.biz.crm.common.ie.local.service.spring.rest.strategy.ParamsParseFactory;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @title MethodParameterTypeParseForRequestParam
 * @date 2023/10/9 13:47
 * @author Kevin
 * @description @RequestParam注解处理
 */
@Component
public class MethodParameterTypeParseForRequestParam implements IMethodParameterTypeParse<Object> {

  @Autowired
  private ParamsParseFactory paramsParseFactory;

  /**
   * 验证注解是否适配
   * @param methodParameter
   * @return
   */
  @Override
  public boolean supportsParameter(final MethodParameter methodParameter) {
    final RequestParam parameterAnnotation = methodParameter.getParameterAnnotation(RequestParam.class);
    return (parameterAnnotation != null);
  }

  /**
   * 处理注解中的属性
   * @param methodParameter
   * @param requestParamMap
   * @return
   * @throws IllegalArgumentException
   */
  @Override
  public Object resolveArgument(MethodParameter methodParameter, Map<String, Object> requestParamMap)
      throws IllegalArgumentException {
    Class<?> parameterType = methodParameter.getParameterType();
    final RequestParam parameterAnnotation = methodParameter.getParameterAnnotation(RequestParam.class);
    String defaultValue = parameterAnnotation.defaultValue();
    Object resolveArgument = paramsParseFactory.resolveArgument(parameterType, defaultValue);
    return resolveArgument;
  }
}
