package com.biz.crm.common.ie.local.service.strategy;

import cn.hutool.json.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.common.ie.sdk.excel.vo.ColumnVo;
import com.biz.crm.common.ie.sdk.service.ExportFieldVoService;
import com.biz.crm.common.ie.sdk.strategy.ExportColumnStrategy;
import com.biz.crm.common.ie.sdk.vo.ExportFieldVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author HanJiaJun
 * @describe:数据视图导出 灵活配置导出策略
 * @createTime 2023年07月26日 17:26:00
 */
@Component
public class FlexibleExportColumnStrategy implements ExportColumnStrategy {

  @Autowired
  private ExportFieldVoService exportFieldVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @Override
  public String getCode() {
    return "flexible";
  }

  @Override
  public String getName() {
    return "灵活配置导出策略";
  }

  @Override
  public List<ColumnVo> getColumn(Set<String> marsField, JSONObject jsonObject) {
    String parentCode = jsonObject.getStr("parentCode");
    String functionCode = jsonObject.getStr("functionCode");
    String menuCode = parentCode.concat("@").concat(functionCode);
    List<ExportFieldVo> list = this.exportFieldVoService.findByMenuCode(menuCode);
    if (CollectionUtils.isEmpty(list)) {
      return new ArrayList<>();
    }
    //过滤数据权限字段,如果set不为空，那么最终返回的字段必须是存在marsField中的!
    List<ExportFieldVo> collect = list.parallelStream()
        .filter(row -> {
          if (marsField == null) {
            return true;
          } else {
            String field = row.getField();
            return marsField.contains(field);
          }
        })
        .collect(Collectors.toList());
    if (CollectionUtils.isEmpty(collect)) {
      return new ArrayList<>();
    }
    return (List<ColumnVo>) this.nebulaToolkitService.copyCollectionByBlankList(collect, ExportFieldVo.class, ColumnVo.class, HashSet.class, ArrayList.class);
  }
}
