/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.bean.ExportTaskExtendsVo;
import com.biz.crm.common.ie.local.entity.ExportTask;
import com.biz.crm.common.ie.local.model.vo.ExportProcessItemModelVo;
import com.biz.crm.common.ie.local.service.ExportTaskService;
import com.biz.crm.common.ie.sdk.dto.CreateExportTaskDto;
import com.biz.crm.common.ie.sdk.dto.ExportTaskPaginationDto;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContext;
import com.bizunited.nebula.mars.sdk.context.MarsAuthorityContextHolder;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u51fa\u4efb\u52a1: ImportTask: \u5bfc\u51fa\u4efb\u52a1"})
@RestController
@RequestMapping(value={"/v1/exportTask/exportTask"})
public class ExportTaskController {
    private static final Logger log = LoggerFactory.getLogger(ExportTaskController.class);
    @Autowired(required=false)
    private ExportTaskService exportTaskService;
    @Autowired(required=false)
    private List<ExportProcess<CrmExcelVo>> exportProcesses;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private RedisMutexService redisMutexService;
    @Autowired
    private LoginUserService loginUserService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ExportTask>> findByConditions(@PageableDefault(value=50) Pageable pageable, ExportTaskPaginationDto paginationDto) {
        try {
            Page<ExportTask> result = this.exportTaskService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6587\u4ef6\u7ba1\u7406-\u53d6\u6d88\u5bfc\u51fa\u4efb\u52a1")
    @PostMapping(value={"/cancelTask"})
    public Result<?> cancelTask(@RequestBody List<String> codes) {
        try {
            this.exportTaskService.cancelTask(codes);
            return Result.ok((String)"\u6267\u884c\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4efb\u52a1\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/findDetailByTaskCode"})
    public Result<ExportTask> findDetailByTaskCode(@RequestParam(value="taskCode") String taskCode) {
        try {
            ExportTask exportTask = this.exportTaskService.findDetailByTaskCode(taskCode);
            return Result.ok((Object)((Object)exportTask));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5bfc\u51fa\u4e1a\u52a1\u6ce8\u518c\u5668\u4e3b\u8981\u4fe1\u606f")
    @GetMapping(value={"/findAllExportBusiness"})
    public Result<List<ExportProcessItemModelVo>> findAllExportBusiness() {
        LinkedList list = Lists.newLinkedList();
        if (CollectionUtils.isEmpty(this.exportProcesses)) {
            return Result.ok((Object)list);
        }
        for (ExportProcess<CrmExcelVo> item : this.exportProcesses) {
            ExportProcessItemModelVo cur = new ExportProcessItemModelVo();
            cur.setBusinessCode(item.getBusinessCode());
            cur.setBusinessName(item.getBusinessName());
            list.add(cur);
        }
        return Result.ok((Object)list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="\u65b0\u5efa\u5bfc\u51fa\u4efb\u52a1")
    @PostMapping(value={""})
    public Result<ExportTaskExtendsVo> create(HttpServletRequest request, @RequestBody CreateExportTaskDto dto) {
        MarsAuthorityContext marsAuthorityContext = MarsAuthorityContextHolder.getContext();
        String listCode = marsAuthorityContext.getListCode();
        dto.setMarsListCode(listCode);
        String lockKey = String.format("%s:%s:%s:%s:%s", "ie_export_create_lock", dto.getParentCode(), dto.getFunctionCode(), dto.getBusinessCode(), this.loginUserService.findCurrentAccount());
        boolean locked = false;
        try {
            locked = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 5);
            Validate.isTrue((boolean)locked, (String)"\u5bfc\u51fa\u4efb\u52a1\u64cd\u4f5c\u9891\u7e41,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", (Object[])new Object[0]);
            dto.getParams().entrySet().removeIf(entry -> entry.getValue() == null || StringUtils.isBlank((CharSequence)("" + entry.getValue())));
            ExportTask current = this.exportTaskService.create(dto);
            int count = this.exportTaskService.getTaskCountByNoExe(current);
            ExportTaskExtendsVo obj = (ExportTaskExtendsVo)((Object)this.nebulaToolkitService.copyObjectByBlankList((Object)current, ExportTaskExtendsVo.class, HashSet.class, ArrayList.class, new String[0]));
            obj.setToBeExecutedTaskNum(count);
            Result result = Result.ok((Object)((Object)obj));
            return result;
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            Result result = Result.error((String)e.getMessage());
            return result;
        }
        finally {
            if (locked) {
                this.redisMutexService.unlock(lockKey);
            }
        }
    }
}

