/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.local.model.vo.ImportTreeModelVo;
import com.biz.crm.common.ie.local.service.ImportTemplateService;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5bfc\u5165\u6a21\u677f: ImportTemplate: \u5bfc\u5165\u6a21\u677f"})
@RestController
@RequestMapping(value={"/v1/importTemplate/importTemplate"})
public class ImportTemplateController {
    private static final Logger log = LoggerFactory.getLogger(ImportTemplateController.class);
    @Autowired
    private ImportTemplateService importTemplateService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ImportTemplate>> findByConditions(@PageableDefault(value=50) Pageable pageable, ImportTemplatePaginationDto paginationDto) {
        try {
            Page<ImportTemplate> result = this.importTemplateService.findByConditions(pageable, paginationDto);
            return Result.ok(result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u83b7\u53d6\u8be6\u60c5")
    @GetMapping(value={"/findDetailByBusinessCode"})
    public Result<ImportTemplate> findDetailByBusinessCode(@RequestParam(value="businessCode") String businessCode) {
        try {
            ImportTemplate importTemplate = this.importTemplateService.findDetailByBusinessCode(businessCode);
            return Result.ok((Object)((Object)importTemplate));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u6a21\u677f\u7ba1\u7406\u4e1a\u52a1-\u6a21\u677f\u4e0b\u62c9\u6811")
    @GetMapping(value={"/findTemplateTree"})
    public Result<List<ImportTreeModelVo>> findTemplateTree() {
        try {
            List<ImportTreeModelVo> list = this.importTemplateService.findTemplateTree();
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u83b7\u53d6\u4e0b\u7ea7\u6a21\u677f\u4e0b\u62c9")
    @GetMapping(value={"/findTemplateSelectByBusinessCode"})
    public Result<List<ImportTreeModelVo>> findTemplateSelectByBusinessCode(@RequestParam(value="businessCode") String businessCode) {
        try {
            List<ImportTreeModelVo> list = this.importTemplateService.findTemplateSelectByBusinessCode(businessCode);
            return Result.ok(list);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u521b\u5efa")
    @PostMapping(value={""})
    public Result<ImportTemplate> create(@RequestBody ImportTemplate importTemplate) {
        try {
            ImportTemplate current = this.importTemplateService.create(importTemplate);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PatchMapping(value={""})
    public Result<ImportTemplate> update(@RequestBody ImportTemplate importTemplate) {
        try {
            ImportTemplate current = this.importTemplateService.update(importTemplate);
            return Result.ok((Object)((Object)current));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u7f16\u7801\u96c6\u5408\u5220\u9664")
    @DeleteMapping(value={"/deleteByBusinessCodes"})
    public Result<?> deleteByBusinessCodes(@RequestParam(value="businessCodes") List<String> businessCodes) {
        try {
            this.importTemplateService.deleteByBusinessCodes(businessCodes);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

