/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.init;

import cn.hutool.core.thread.ThreadUtil;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.task.ImportExportMasterKeeperTask;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component(value="_-_ImportExportTaskInitProcess")
@Order(value=1)
public class ImportExportTaskInitProcess
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(ImportExportTaskInitProcess.class);
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private List<ImportProcess<?>> importProcesses;
    @Autowired(required=false)
    private List<ExportProcess<?>> exportProcesses;

    public void run(String ... args) throws Exception {
        this.validateProcessRepeat();
        ImportExportMasterKeeperTask task = (ImportExportMasterKeeperTask)this.applicationContext.getBean(ImportExportMasterKeeperTask.class);
        if (this.importExportProperties.getExecTask().booleanValue()) {
            ThreadUtil.execAsync((Runnable)task, (boolean)true);
            log.info("\u7cfb\u7edf\u914d\u7f6e\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1--\u542f\u52a8\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        } else {
            log.warn("\u7cfb\u7edf\u914d\u7f6e\u5bfc\u5165\u5bfc\u51fa\u4efb\u52a1--\u7981\u7528\uff01\uff01\uff01\uff01\uff01\uff01\uff01");
        }
    }

    private void validateProcessRepeat() {
        StringBuilder sb = new StringBuilder();
        if (CollectionUtils.isNotEmpty(this.importProcesses)) {
            HashSet importCodeSet = Sets.newHashSet();
            Set repeatImportCodeSet = this.importProcesses.stream().filter(a -> !importCodeSet.add(a.getTemplateCode())).map(ImportProcess::getTemplateCode).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(repeatImportCodeSet)) {
                sb.append("\u5bfc\u5165\u6a21\u677f\u7f16\u7801").append(String.join((CharSequence)",", repeatImportCodeSet)).append("\u5b58\u5728\u91cd\u590d");
            }
        }
        if (CollectionUtils.isNotEmpty(this.exportProcesses)) {
            HashSet exportCodeSet = Sets.newHashSet();
            Set repeatExportCodeSet = this.exportProcesses.stream().filter(a -> !exportCodeSet.add(a.getBusinessCode())).map(ExportProcess::getBusinessCode).collect(Collectors.toSet());
            if (CollectionUtils.isNotEmpty(repeatExportCodeSet)) {
                sb.append("\u5bfc\u51fa\u6a21\u677f\u7f16\u7801").append(String.join((CharSequence)",", repeatExportCodeSet)).append("\u5b58\u5728\u91cd\u590d");
            }
        }
        Validate.isTrue((sb.length() == 0 ? 1 : 0) != 0, (String)sb.toString(), (Object[])new Object[0]);
    }
}

