package com.biz.crm.common.ie.local.service;

import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import java.util.List;

/**
 * 导入模板明细(ImportTemplateDetail)表服务接口
 *
 * @author sunx
 * @date 2022-05-10 10:57:20
 */
public interface ImportTemplateDetailService {

  /**
   * 按businessCode查询详情
   *
   * @param businessCode 业务编码
   * @return
   */
  List<ImportTemplateDetail> findDetailByBusinessCode(String businessCode);

  /**
   * 批量新增模板明细信息
   *
   * @param list 模板集合
   * @param businessCode 业务编码
   * @return
   */
  void createBatch(List<ImportTemplateDetail> list, String businessCode);

  /**
   * 根据业务编码删除
   *
   * @param businessCodes 业务编码集合
   */
  void deleteByBusinessCodes(List<String> businessCodes);
}
