package com.biz.crm.common.ie.local.service.init;

import com.bizunited.nebula.init.service.InitProcessEnvironmentService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

/**
 * 导入导出租户信息初始化
 * 
 * @author xzkne
 */
@Slf4j
@Component
public class ImportExportInitProcessEnvServ implements InitProcessEnvironmentService {
  /**
   * 当前系统租户信息
   */
  @Getter
  private List<String> appCodeList = new ArrayList<>();

  /**
   * 当应用程序启动时，根据应用程序完成初始化操作的过程
   * 
   * @param appCode 应用级别appCode，实际上就是顶级租户tenantCode，来源于当前应用程序默认数据库中app_data_source数据表中的信息
   */
  @Override
  public void initForAppCode(String appCode) {
    log.debug("租户登记{}，threadId：{}", appCode,Thread.currentThread().getId());
    // 记录当前系统有哪些租户
    appCodeList.add(appCode);
  }

  /**
   * 有的(应用级别appCode，实际上就是顶级租户tenantCode)初始化过程并不是每次进程启动都要进行的，例如平台基础工具套件在进行角色初始化时，只需要在第一次进程启动时进行；
   * </p>
   * 所以初始化动作需要该方法进行控制，如果返回true则表示本次进行启动时，需要进行初始化；其它情况则表示不需要运行初始化动作
   */
  @Override
  public boolean doInitForAppCode(String appCode) {
    // 将所有租户都统计下来
    return true;
  }

}
