package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseForFloat
 * @date 2023/10/10 10:26
 * @author Kevin
 * @description float类型
 */
@Component
public class RequestParamParseForFloat implements IRequestParamParse<Float> {

  @Override
  public boolean isApplicable(Class<?> parameterType) {
    return parameterType == Float.TYPE;
  }

  @Override
  public Float getValue(String defaultValueString) throws IllegalArgumentException {
    return new Float(defaultValueString);
  }
}
