package com.biz.crm.common.ie.local.service.spring.rest.impl;

import com.biz.crm.common.ie.local.service.spring.rest.IRequestParamParse;
import org.springframework.stereotype.Component;

/**
 * @title RequestParamParseForInteger
 * @date 2023/10/10 10:27
 * @author Kevin
 * @description Integer类型
 */
@Component
public class RequestParamParseForInteger implements IRequestParamParse<Integer> {

  @Override
  public boolean isApplicable(Class<?> parameterType) {
    return parameterType == Integer.TYPE;
  }

  @Override
  public Integer getValue(String defaultValueString) throws IllegalArgumentException {
    return new Integer(defaultValueString);
  }
}
