/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task.tools;

import com.biz.crm.business.common.identity.FacturerUserDetails;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class TaskExecutorAuthTool {
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorAuthTool.class);

    public static void refreshUseAuthAndTenantCode(LoginUserService loginUserService, IeExecutorVo vo, Integer userDefaultLoginType) {
        String taskTenantCode = vo.getTenantCode();
        String account = vo.getAccount();
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        FacturerUserDetails facturer = null;
        if (facturer == null) {
            ArrayList authorities = new ArrayList();
            facturer = new FacturerUserDetails();
            facturer.setAccount(account);
            facturer.setTenantCode(taskTenantCode);
            facturer.setIdentityType("u");
            facturer.setLoginType(userDefaultLoginType);
            facturer.setRoleCodes(new String[]{"ADMIN"});
            UsernamePasswordAuthenticationToken autoObj = new UsernamePasswordAuthenticationToken((Object)account, (Object)"xzk-001", authorities);
            autoObj.setDetails((Object)facturer);
            SecurityContextHolder.getContext().setAuthentication((Authentication)autoObj);
        }
        log.debug("* \u91cd\u5efa\u7528\u6237\u6743\u9650 *");
        TaskGlobalParamsVo paramsVo = new TaskGlobalParamsVo();
        String appCode = vo.getAppCode();
        paramsVo.setAppCode(appCode);
        paramsVo.setTenantCode(taskTenantCode);
        paramsVo.setCreateAccount(vo.getAccount());
        paramsVo.setCreateAccountName(vo.getAccountName());
        paramsVo.setTaskCode(vo.getTaskCode());
        paramsVo.setApplicationName(vo.getApplicationName());
        Authentication refreshAuthentication = loginUserService.refreshAuthentication((Object)paramsVo);
        String tenantCode = TenantUtils.getTenantCode();
        Validate.isTrue((true == StringUtils.equals((CharSequence)taskTenantCode, (CharSequence)tenantCode) ? 1 : 0) != 0, (String)"\u79df\u6237TenantCode\u5237\u65b0\u5931\u8d25=%s", (Object[])new Object[]{taskTenantCode});
    }
}

