/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.concurrent.threadpool.priority;

import com.biz.crm.common.ie.local.concurrent.threadpool.priority.FutureTaskComparable;
import java.util.concurrent.Callable;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutorPriorityBlocking
extends ThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolExecutorPriorityBlocking.class);

    public ThreadPoolExecutorPriorityBlocking(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, PriorityBlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public <T> FutureTaskComparable<T> submit(Callable<T> task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor((Callable)task);
        this.execute(ftask);
        return ftask;
    }

    public FutureTaskComparable<?> submit(Runnable task) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, (Object)null);
        this.execute(ftask);
        return ftask;
    }

    public <T> FutureTaskComparable<T> submit(Runnable task, T result) {
        if (task == null) {
            throw new NullPointerException();
        }
        RunnableFuture ftask = this.newTaskFor(task, (Object)result);
        this.execute(ftask);
        return ftask;
    }

    protected <T> FutureTaskComparable<T> newTaskFor(Callable<T> callable) {
        return new FutureTaskComparable<T>(callable);
    }

    @Override
    public void execute(Runnable command) {
        super.execute(command);
    }

    protected <T> FutureTaskComparable<T> newTaskFor(Runnable runnable, T value) {
        return new FutureTaskComparable<T>(runnable, value);
    }
}

