/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.exports.webapi;

import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.service.spring.SpringControllerApiService;
import com.biz.crm.common.ie.sdk.constant.ImportExportConstant;
import com.biz.crm.common.ie.sdk.dto.ExportWebApiDto;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.common.ie.sdk.vo.WebApiExportVo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class WebApiExportProcess
implements ExportProcess<WebApiExportVo> {
    @Autowired
    private ImportExportProperties importExportProperties;
    @Autowired
    private SpringControllerApiService springControllerApiService;

    public String getBusinessCode() {
        return "EXPORT_WEB_API";
    }

    public String getBusinessName() {
        return "webApi\u5bfc\u51fa";
    }

    public Integer getPageSize() {
        return ImportExportConstant.IE_EXPORT_PAGE_SIZE;
    }

    public Class<WebApiExportVo> findCrmExcelVoClass() {
        throw new RuntimeException("webApi\u5bfc\u51fa\u4e0d\u4f9d\u8d56\u8be5\u65b9\u6cd5\u8fd4\u56deExcel\u8868\u5934\uff0c\u6ce8\u610f\u7ea0\u6b63");
    }

    public Integer getTotal(Map<String, Object> params) {
        ExportWebApiDto exportWebApiDto = this.getWebApiParam(params);
        String requestParamJson = this.getRequestParamFilterWebUrl(params);
        Long pageTotal = this.springControllerApiService.getPageTotal(exportWebApiDto.getWebApiUrl(), exportWebApiDto.getRequestMapping(), requestParamJson);
        return pageTotal.intValue();
    }

    private String getRequestParamFilterWebUrl(Map<String, Object> params) {
        HashMap requestParamMap = Maps.newHashMap(params);
        requestParamMap.remove("webApiUrl");
        String requestParamJson = JSONUtil.toJsonStr((Object)requestParamMap);
        return requestParamJson;
    }

    private ExportWebApiDto getWebApiParam(Map<String, Object> params) {
        Object requestMapping = params.get("requestMapping");
        Validate.notNull((Object)requestMapping, (String)"webApi\u5bfc\u51fa\u65f6\uff0c\u8bf7\u6c42\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Object url = params.get("webApiUrl");
        Validate.notNull((Object)url, (String)"webApi\u5bfc\u51fa\u65f6\uff0curl\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ExportWebApiDto exportWebApiDto = new ExportWebApiDto();
        exportWebApiDto.setWebApiUrl((String)url);
        String requestMappingType = (String)requestMapping;
        exportWebApiDto.setRequestMapping(requestMappingType.toUpperCase());
        return exportWebApiDto;
    }

    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        Pageable pageable = this.buildPageable(params);
        params.put("webApiUrl", vo.getWebApiUrl());
        ExportWebApiDto webApiDto = this.getWebApiParam(params);
        String requestParamJson = this.getRequestParamFilterWebUrl(params);
        int pageNum = pageable.getPageNumber() + webApiDto.getStartPage();
        IPage<?> page = this.springControllerApiService.getPage(webApiDto.getWebApiUrl(), webApiDto.getRequestMapping(), requestParamJson, pageNum, pageable.getPageSize());
        params.remove("webApiUrl");
        if (CollectionUtils.isEmpty((Collection)page.getRecords())) {
            return null;
        }
        List records = page.getRecords();
        this.adjustData(records);
        return this.toJSONArray(records);
    }

    private void adjustData(List<?> records) {
        if (CollectionUtils.isEmpty(records)) {
            return;
        }
    }
}

