/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.common.ie.local.entity.ExportField;
import com.biz.crm.common.ie.local.repository.ExportFieldRepository;
import com.biz.crm.common.ie.sdk.dto.ExportFieldDto;
import com.biz.crm.common.ie.sdk.service.ExportFieldVoService;
import com.biz.crm.common.ie.sdk.vo.ExportFieldVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ExportFieldVoServiceImpl
implements ExportFieldVoService {
    @Autowired
    private ExportFieldRepository exportFieldRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public List<ExportFieldVo> findByMenuCode(String menuCode) {
        Validate.notBlank((CharSequence)menuCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        String tenantCode = TenantUtils.getTenantCode();
        String currentAccount = this.loginUserService.findCurrentAccount();
        List<ExportField> list = this.exportFieldRepository.findByMenuCode(tenantCode, currentAccount, menuCode);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ExportFieldVo>();
        }
        return (List)this.nebulaToolkitService.copyCollectionByBlankList(list, ExportField.class, ExportFieldVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void save(List<ExportFieldDto> fieldList) {
        Validate.notEmpty(fieldList, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u4fe1\u606f", (Object[])new Object[0]);
        String menuCode = this.validateAndGetMenuCode(fieldList);
        String currentAccount = this.loginUserService.findCurrentAccount();
        String tenantCode = TenantUtils.getTenantCode();
        this.exportFieldRepository.deleteByMenuCode(tenantCode, currentAccount, menuCode);
        List entity = (List)this.nebulaToolkitService.copyCollectionByBlankList(fieldList, ExportFieldDto.class, ExportField.class, HashSet.class, ArrayList.class, new String[0]);
        for (int i = 0; i < entity.size(); ++i) {
            ExportField exportField = (ExportField)((Object)entity.get(i));
            exportField.setFormOrder(i);
        }
        this.exportFieldRepository.saveBatch(entity);
    }

    private String validateAndGetMenuCode(List<ExportFieldDto> fieldList) {
        String menuCode = null;
        Set menuCodeSet = fieldList.stream().map(ExportFieldDto::getMenuCode).collect(Collectors.toSet());
        Validate.isTrue((CollectionUtils.isNotEmpty(menuCodeSet) && menuCodeSet.size() == 1 ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u5bfc\u51fa\u5b57\u6bb5\u65f6\uff0c\u96c6\u5408\u6570\u636e\u83dc\u5355\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u8005\u5b58\u5728\u591a\u4e2a\uff01", (Object[])new Object[0]);
        menuCode = (String)menuCodeSet.iterator().next();
        for (ExportFieldDto field : fieldList) {
            Validate.notNull((Object)field, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u4fe1\u606f", (Object[])new Object[0]);
            Validate.isTrue((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{field.getField(), field.getTitle(), field.getMenuCode()}), (String)"\u5bfc\u51fa\u5b57\u6bb5\u4fdd\u5b58\u5fc5\u586b\u9879\u6821\u9a8c\u5931\u8d25\uff0c\u68c0\u67e5\u63d0\u4ea4\u6570\u636e", (Object[])new Object[0]);
            String tenantCode = TenantUtils.getTenantCode();
            String currentAccount = this.loginUserService.findCurrentAccount();
            field.setAccount(currentAccount);
            field.setTenantCode(tenantCode);
        }
        return menuCode;
    }
}

