/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.internal;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.utils.MultipartFileUtil;
import com.biz.crm.common.ie.local.bean.ImportSendProcessMsgBean;
import com.biz.crm.common.ie.local.config.ImportExportProperties;
import com.biz.crm.common.ie.local.entity.ImportTask;
import com.biz.crm.common.ie.local.entity.ImportTemplateDetail;
import com.biz.crm.common.ie.local.model.vo.ImportTaskUpdateModelVo;
import com.biz.crm.common.ie.local.repository.ImportTaskRepository;
import com.biz.crm.common.ie.local.repository.ImportTemplateDetailRepository;
import com.biz.crm.common.ie.local.service.internal.ImportTaskThreadLocalServImpl;
import com.biz.crm.common.ie.sdk.enums.CallbackStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ExcelFileTypeEnum;
import com.biz.crm.common.ie.sdk.enums.ExecStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ImportDataStatusEnum;
import com.biz.crm.common.ie.sdk.enums.ImportProcessEnum;
import com.biz.crm.common.ie.sdk.enums.TypeEnum;
import com.biz.crm.common.ie.sdk.event.ImportNotifyEventListener;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.excel.strategy.CrmExcelProcessStrategy;
import com.biz.crm.common.ie.sdk.service.ImportProcessService;
import com.biz.crm.common.ie.sdk.vo.ExcelFileVo;
import com.biz.crm.common.ie.sdk.vo.IeExecutorVo;
import com.biz.crm.common.ie.sdk.vo.ImportExcelLocalFile;
import com.biz.crm.common.ie.sdk.vo.ImportProcessMsgVo;
import com.biz.crm.common.ie.sdk.vo.ImportTaskEventVo;
import com.biz.crm.common.ie.sdk.vo.ImportTaskHandlerResultVo;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import com.bizunited.nebula.venus.sdk.dto.Base64UploadDto;
import com.bizunited.nebula.venus.sdk.service.file.FileHandleService;
import com.bizunited.nebula.venus.sdk.vo.OrdinaryFileVo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import feign.FeignException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Base64Utils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StopWatch;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ImportProcessServiceImpl
implements ImportProcessService {
    private static final Logger log = LoggerFactory.getLogger(ImportProcessServiceImpl.class);
    @Autowired(required=false)
    private ImportTaskThreadLocalServImpl importTaskThreadLocalServImpl;
    @Autowired(required=false)
    private ImportTemplateDetailRepository importTemplateDetailRepository;
    @Value(value="${spring.application.name:}")
    private String subsystem;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private FileHandleService fileHandleService;
    @Autowired(required=false)
    private ImportSendProcessMsgBean importSendProcessMsgBean;
    @Autowired(required=false)
    private List<ImportProcess> importProcesses;
    @Autowired(required=false)
    private CrmExcelProcessStrategy crmExcelProcessStrategy;
    @Autowired(required=false)
    private ImportExportProperties importExportProperties;
    @Autowired(required=false)
    private List<ImportNotifyEventListener> notifyEventListeners;
    @Autowired(required=false)
    private RedisMutexService redisMutexService;
    @Autowired(required=false)
    private ImportTaskRepository importTaskRepository;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importProcess(IeExecutorVo vo) {
        try {
            boolean f;
            ImportTask task = this.importTaskThreadLocalServImpl.findByTaskCode(vo.getTaskCode());
            OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(task.getFileCode());
            ImportProcessMsgVo msgVo = new ImportProcessMsgVo();
            msgVo.setTaskCode(vo.getTaskCode());
            msgVo.setIeType(TypeEnum.IMPORT.getDictCode());
            msgVo.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            msgVo.setProcessType(ImportProcessEnum.GET_PROCESS.getCode());
            msgVo.setRemark("\u63a8\u9001\u6587\u4ef6\u540d\u79f0");
            msgVo.setAccount(task.getCreateAccount());
            msgVo.setApplicationName(this.subsystem);
            if (ordinaryFileVo != null) {
                msgVo.setFileName(ordinaryFileVo.getOriginalFileName());
            }
            this.importSendProcessMsgBean.sendMsgByAll(msgVo);
            vo.setAccount(task.getCreateAccount());
            Validate.notNull((Object)((Object)task), (String)CharSequenceUtil.format((CharSequence)"\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e3a{}\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
            boolean bl = f = task.getExecStatus().equals(ExecStatusEnum.CANCEL.getDictCode()) || task.getExecStatus().equals(ExecStatusEnum.FINISH.getDictCode());
            if (f) {
                this.importTaskThreadLocalServImpl.clean();
                return;
            }
            this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), ImportProcessEnum.START, vo.getAccount());
            this.process(vo);
            ImportTask importTask = this.importTaskThreadLocalServImpl.findByTaskCode(vo.getTaskCode());
            ExecStatusEnum execStatusEnum = null;
            ImportProcessEnum importProcessEnum = null;
            if (importTask.getFailedNum() == 0) {
                execStatusEnum = ExecStatusEnum.FINISH;
            } else {
                importProcessEnum = ImportProcessEnum.VERIFY_FAIL;
                execStatusEnum = Objects.equals(importTask.getTotal(), importTask.getFailedNum()) ? ExecStatusEnum.FAILED : ExecStatusEnum.PARTIAL_SUCCESS;
                this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), importProcessEnum, execStatusEnum.getDictCode(), importProcessEnum.getDesc(), vo.getAccount(), importTask);
                ThreadUtil.sleep((long)20L);
            }
            importProcessEnum = ImportProcessEnum.END;
            this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), importProcessEnum, execStatusEnum.getDictCode(), importProcessEnum.getDesc(), vo.getAccount(), importTask);
        }
        catch (FeignException fe) {
            this.handlerTaskFailed(vo.getTaskCode(), "\u5bfc\u5165Feign\u8c03\u7528\u5931\u8d25", vo.getAccount());
            log.error("\u5bfc\u5165\u4efb\u52a1{}\u8c03\u7528Fegin\u5931\u8d25,err[{}]", (Object)vo.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)fe));
        }
        catch (RuntimeException ex) {
            this.handlerTaskFailed(vo.getTaskCode(), ex.getMessage(), vo.getAccount());
            log.error("\u5bfc\u5165\u4efb\u52a1{}\u5904\u7406\u5931\u8d25,err[{}]", (Object)vo.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)ex));
        }
        catch (Exception ex) {
            this.handlerTaskFailed(vo.getTaskCode(), "\u5bfc\u5165\u5931\u8d25", vo.getAccount());
            log.error("\u5bfc\u5165\u4efb\u52a1{}\u5904\u7406\u5931\u8d25,err[{}]", (Object)vo.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)ex));
        }
        finally {
            this.callBack(vo.getTaskCode());
            this.importTaskThreadLocalServImpl.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(IeExecutorVo vo) {
        OrdinaryFileVo templateFileVo;
        StopWatch sw = new StopWatch(CharSequenceUtil.format((CharSequence)"\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}", (Object[])new Object[]{vo.getTaskCode()}));
        sw.start("1\u3001\u4efb\u52a1\u9884\u5904\u7406");
        ImportTask task = this.importTaskHandler(vo);
        ImportTemplateDetail templateDetail = this.importTemplateDetailRepository.findDetailByTemplateCode(task.getTemplateCode());
        Validate.notNull((Object)((Object)templateDetail), (String)"\u672a\u914d\u7f6e\u5bfc\u5165\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        String templateFileCode = templateDetail.getFileCode();
        Validate.notEmpty((CharSequence)templateFileCode, (String)"\u672a\u914d\u7f6e\u5bfc\u5165\u7684\u6a21\u677f\u4fe1\u606f", (Object[])new Object[0]);
        sw.stop();
        this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), ImportProcessEnum.GET_PROCESS, vo.getAccount());
        ImportProcess process = this.findImportProcess(task.getTemplateCode());
        CrmExcelImport crmExcelImport = process.findCrmExcelVoClass().getAnnotation(CrmExcelImport.class);
        Validate.notNull((Object)crmExcelImport, (String)"excel\u5bfc\u5165bean\u672a\u914d\u7f6eCrmExcelImport\u6ce8\u89e3", (Object[])new Object[0]);
        Field[] fields = ReflectUtil.getFields((Class)process.findCrmExcelVoClass());
        long count = Stream.of(fields).filter(a -> Objects.nonNull(a.getAnnotation(CrmExcelColumn.class))).count();
        Validate.isTrue((count > 0L ? 1 : 0) != 0, (String)"excel\u5bfc\u5165bean\u7684\u5b57\u6bb5\u5c5e\u6027\u672a\u914d\u7f6eCrmExcelColumn\u6ce8\u89e3", (Object[])new Object[0]);
        sw.start("3\u3001\u83b7\u53d6\u539f\u6587\u4ef6+\u6a21\u677f\u6587\u4ef6\u4fe1\u606f");
        this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), ImportProcessEnum.DOWNLOAD, vo.getAccount());
        HashMap downloadFileMap = Maps.newHashMap();
        OrdinaryFileVo ordinaryFileVo = this.fileHandleService.findById(task.getFileCode());
        if (ordinaryFileVo != null) {
            downloadFileMap.put(task.getFileCode(), ordinaryFileVo);
        }
        if ((templateFileVo = this.fileHandleService.findById(templateFileCode)) != null) {
            downloadFileMap.put(templateFileCode, templateFileVo);
        }
        boolean fileFlag = downloadFileMap.containsKey(task.getFileCode()) && ((OrdinaryFileVo)downloadFileMap.get(task.getFileCode())).getFileSize() > 0L;
        Validate.isTrue((boolean)fileFlag, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1{}\u5bf9\u5e94\u7684\u539f\u6587\u4ef6\u4fe1\u606f", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        boolean templateFileFlag = downloadFileMap.containsKey(templateFileCode) && ((OrdinaryFileVo)downloadFileMap.get(templateFileCode)).getFileSize() > 0L;
        Validate.isTrue((boolean)templateFileFlag, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u4efb\u52a1{}\u5bf9\u5e94\u7684\u6a21\u677f\u6587\u4ef6\u4fe1\u606f", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        sw.stop();
        sw.start("4\u3001\u5904\u7406excel\u5bfc\u5165");
        ImportExcelLocalFile localExcelFileMap = this.createLocalExcelFile(downloadFileMap, task.getFileCode(), templateFileCode, task.getTaskCode());
        String parentPath = localExcelFileMap.getOrdinaryFile().getParentPath();
        this.importSendProcessMsgBean.sendProcessMsg(vo.getTaskCode(), ImportProcessEnum.START_EXEC, vo.getAccount());
        try {
            this.excelHandler(task, process, localExcelFileMap);
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u51fa\u9519\u4e86{},error[{}]", (Object)vo.getTaskCode(), (Object)Throwables.getStackTraceAsString((Throwable)e));
            Validate.isTrue((boolean)false, (String)e.getMessage(), (Object[])new Object[0]);
        }
        finally {
            FileUtil.del((String)parentPath);
        }
        sw.stop();
        log.info(CharSequenceUtil.format((CharSequence)"******\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}\uff0c\u6267\u884c\u7edf\u8ba1{}****", (Object[])new Object[]{vo.getTaskCode(), sw.prettyPrint()}));
    }

    private List<OrdinaryFileVo> venusFileUpload(MultipartFile multipartFile) throws IOException {
        Base64UploadDto base64UploadDto = new Base64UploadDto();
        base64UploadDto.setCreator(this.loginUserService.findCurrentAccount());
        base64UploadDto.setFileNanmes(new String[]{multipartFile.getOriginalFilename()});
        base64UploadDto.setBase64Contents(new String[]{Base64Utils.encodeToString((byte[])multipartFile.getBytes())});
        List ordinaryFileVoList = this.fileHandleService.fileUpload(this.subsystem.replace("-", "_"), base64UploadDto, null);
        Validate.notEmpty((Collection)ordinaryFileVoList, (String)"\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01", (Object[])new Object[0]);
        return ordinaryFileVoList;
    }

    private void excelHandler(ImportTask task, ImportProcess process, ImportExcelLocalFile localFile) {
        if (localFile == null || localFile.getOrdinaryFile() == null || localFile.getTemplateFile() == null) {
            Validate.isTrue((boolean)false, (String)"\u4efb\u52a1\u6587\u4ef6\u52a0\u8f7d\u5931\u8d25", (Object[])new Object[0]);
        }
        ExcelFileVo originalFile = localFile.getOrdinaryFile();
        ExcelFileVo templateFile = localFile.getTemplateFile();
        String account = task.getCreateAccount();
        String taskCode = task.getTaskCode();
        StopWatch sw = new StopWatch(CharSequenceUtil.format((CharSequence)"====\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}-excel\u5904\u7406===", (Object[])new Object[]{taskCode}));
        Map<String, Object> params = this.findParamsMap(task);
        TaskGlobalParamsVo paramsVo = this.findParams(task);
        String failedFileCode = "";
        sw.start("excel\u903b\u8f91\u5904\u7406");
        ImportTaskHandlerResultVo resultVo = this.crmExcelProcessStrategy.importExcel(process, paramsVo, params, localFile);
        sw.stop();
        ExcelFileVo errorFileVo = localFile.getErrorFile();
        File errorFile = new File(errorFileVo.getPath());
        if (FileUtil.exist((File)errorFile) && FileUtil.size((File)FileUtil.file((File)errorFile, (String[])new String[0])) > 0L) {
            this.importSendProcessMsgBean.sendProcessMsg(taskCode, ImportProcessEnum.ERROR_DATA, account);
            sw.start("\u4e0a\u4f20\u9519\u8bef\u6587\u4ef6");
            try (BufferedInputStream inputStream = FileUtil.getInputStream((File)errorFile);){
                MultipartFile multipartFile = MultipartFileUtil.getMultipartFile((InputStream)inputStream, (String)errorFileVo.getFileName());
                OrdinaryFileVo uploadVo = this.venusFileUpload(multipartFile).get(0);
                failedFileCode = uploadVo.getId();
            }
            catch (Exception e) {
                log.error("\u4e0a\u4f20\u9519\u8bef\u6587\u4ef6\u5931\u8d25{},[{}]", (Object)taskCode, (Object)Throwables.getStackTraceAsString((Throwable)e));
                Validate.isTrue((boolean)false, (String)"\u4e0a\u4f20\u9519\u8bef\u6587\u4ef6\u5931\u8d25", (Object[])new Object[0]);
            }
            sw.stop();
        }
        this.importSendProcessMsgBean.sendProcessMsg(taskCode, ImportProcessEnum.UPDATE_TASK, account);
        ImportTaskUpdateModelVo cur = new ImportTaskUpdateModelVo();
        cur.setTaskCode(taskCode);
        cur.setExecStatus(ExecStatusEnum.FINISH.getDictCode());
        cur.setTotal(resultVo.getTotal());
        cur.setFailedNum(resultVo.getFailedNum());
        cur.setImportDataStatus(resultVo.getImportDataStatus());
        cur.setFailedFileCode(failedFileCode);
        sw.start("\u66f4\u65b0\u4efb\u52a1\u72b6\u6001");
        this.importTaskThreadLocalServImpl.updateByImportTaskUpdateModelVo(cur);
        sw.stop();
        log.info(CharSequenceUtil.format((CharSequence)"+++++\u5bfc\u5165\u4efb\u52a1\u6267\u884c{}-excel\u5904\u7406\uff0c\u6267\u884c\u7edf\u8ba1{}++++", (Object[])new Object[]{taskCode, sw.prettyPrint()}));
    }

    private ImportTask importTaskHandler(IeExecutorVo vo) {
        ImportTask task = this.importTaskThreadLocalServImpl.findByTaskCode(vo.getTaskCode());
        Validate.notNull((Object)((Object)task), (String)CharSequenceUtil.format((CharSequence)"\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e3a{}\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        boolean f = task.getExecStatus().equals(ExecStatusEnum.CANCEL.getDictCode()) || task.getExecStatus().equals(ExecStatusEnum.FINISH.getDictCode());
        Validate.isTrue((!f ? 1 : 0) != 0, (String)CharSequenceUtil.format((CharSequence)"\u5bfc\u5165\u4efb\u52a1\u7f16\u7801\u4e3a{}\u7684\u4efb\u52a1\u5df2\u5b8c\u6210\u6216\u53d6\u6d88", (Object[])new Object[]{vo.getTaskCode()}), (Object[])new Object[0]);
        if (task.getExecStatus().equals(ExecStatusEnum.DEFAULT.getDictCode())) {
            ImportTaskUpdateModelVo cur = new ImportTaskUpdateModelVo();
            cur.setTaskCode(vo.getTaskCode());
            cur.setLoadStatus(vo.getLoadStatus());
            cur.setExecStatus(ExecStatusEnum.RUNNING.getDictCode());
            this.importTaskThreadLocalServImpl.updateByImportTaskUpdateModelVo(cur);
        }
        return task;
    }

    private Map<String, Object> findParamsMap(ImportTask importTask) {
        if (Objects.isNull((Object)importTask) || StringUtils.isBlank((CharSequence)importTask.getParametersJson())) {
            return Maps.newHashMap();
        }
        HashMap map = Maps.newHashMap();
        JSONObject jsonObject = JSONUtil.parseObj((String)importTask.getParametersJson());
        Set set = jsonObject.keySet();
        for (String item : set) {
            map.put(item, jsonObject.get((Object)item));
        }
        return map;
    }

    private ImportProcess findImportProcess(String code) {
        if (CollectionUtils.isEmpty(this.importProcesses) || StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        Optional<ImportProcess> op = this.importProcesses.stream().filter(item -> item.getTemplateCode().equals(code)).findFirst();
        Validate.notNull(op, (String)CharSequenceUtil.format((CharSequence)"\u672a\u83b7\u53d6\u5230\u6a21\u677f\u7f16\u7801{}\u5bf9\u5e94\u7684\u5904\u7406\u5668\u4fe1\u606f", (Object[])new Object[]{code}), (Object[])new Object[0]);
        return op.orElse(null);
    }

    private ImportExcelLocalFile createLocalExcelFile(Map<String, OrdinaryFileVo> downloadFileMap, String fileCode, String templateFileCode, String taskCode) {
        ImportExcelLocalFile localFile = new ImportExcelLocalFile();
        if (downloadFileMap == null || !downloadFileMap.containsKey(fileCode) || !downloadFileMap.containsKey(templateFileCode)) {
            return localFile;
        }
        OrdinaryFileVo ordinaryFileVo = downloadFileMap.get(fileCode);
        OrdinaryFileVo templateFileVo = downloadFileMap.get(templateFileCode);
        Date now = new Date();
        String root = this.importExportProperties.getRoot();
        if (StringUtils.isBlank((CharSequence)root)) {
            root = FileUtil.getTmpDirPath();
        }
        if (root.endsWith("/")) {
            root = root.substring(0, root.length() - 1);
        }
        String parentPath = CharSequenceUtil.format((CharSequence)"{}/import/{}/{}", (Object[])new Object[]{root, DateUtil.format((Date)now, (String)"yyyy/MM-dd"), fileCode});
        String originalFileName = ordinaryFileVo.getOriginalFileName();
        File ordinaryFile = new File(parentPath, originalFileName);
        String templateFileName = originalFileName.substring(0, originalFileName.lastIndexOf("."));
        templateFileName = templateFileName + "_" + ExcelFileTypeEnum.TEMPLATE.getValue() + ".xlsx";
        File templateFile = new File(parentPath, templateFileName);
        String errorFileName = this.crmExcelProcessStrategy.getErrorExcelFileName(originalFileName);
        File errorFile = new File(parentPath, errorFileName);
        CountDownLatch latch = new CountDownLatch(2);
        byte[] bytes = this.fileHandleService.findContentByFilePathAndFileRename(ordinaryFileVo.getRelativeLocal(), ordinaryFileVo.getFileName());
        if (bytes == null) {
            throw new RuntimeException("ERR230904-0102:\u4e0b\u8f7d\u5bfc\u5165\u6587\u4ef6\u5f02\u5e38:" + ordinaryFileVo);
        }
        byte[] writeBytes = bytes;
        Thread writeFileThread = new Thread(() -> {
            File tmpFile = ordinaryFile;
            try {
                Thread.currentThread().setName("\u6587\u4ef6\u5199\u5165" + tmpFile);
                FileUtil.writeBytes((byte[])writeBytes, (File)tmpFile);
                ExcelFileVo vo = this.convertExcelFileVo(tmpFile);
                localFile.setOrdinaryFile(vo);
            }
            catch (Exception e) {
                log.error("ERR230904-0101:\u5bfc\u5165\u6587\u4ef6\u5199\u5165\u5f02\u5e38:" + tmpFile, (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        });
        writeFileThread.start();
        bytes = this.fileHandleService.findContentByFilePathAndFileRename(templateFileVo.getRelativeLocal(), templateFileVo.getFileName());
        if (bytes == null) {
            throw new RuntimeException("ERR230904-0202:\u4e0b\u8f7d\u6a21\u677f\u6587\u4ef6\u5f02\u5e38:" + ordinaryFileVo);
        }
        writeBytes = bytes;
        writeFileThread = new Thread(() -> {
            File tmpFile = templateFile;
            try {
                Thread.currentThread().setName("\u6587\u4ef6\u5199\u5165" + tmpFile);
                FileUtil.writeBytes((byte[])writeBytes, (File)tmpFile);
                ExcelFileVo vo = this.convertExcelFileVo(tmpFile);
                localFile.setTemplateFile(vo);
            }
            catch (Exception e) {
                log.error("ERR230904-0201:\u6a21\u677f\u6587\u4ef6\u5199\u5165\u5f02\u5e38:" + tmpFile, (Throwable)e);
            }
            finally {
                latch.countDown();
            }
        });
        writeFileThread.start();
        ExcelFileVo errorFileExcelFileVo = this.convertExcelFileVo(errorFile);
        localFile.setErrorFile(errorFileExcelFileVo);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            log.error("\u5199\u5165\u672c\u5730\u6587\u4ef6\u53d1\u751f\u5f02\u5e38{}", (Throwable)e);
            throw new RuntimeException("\u7b49\u5f85\u5199\u5165\u6587\u4ef6\u5f02\u5e38", e);
        }
        Validate.isTrue((localFile.getOrdinaryFile() != null ? 1 : 0) != 0, (String)"ERR230904-0301:\u5bfc\u5165\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25 %s", (Object[])new Object[]{taskCode});
        Validate.isTrue((localFile.getTemplateFile() != null ? 1 : 0) != 0, (String)"ERR230904-0302:\u5bfc\u5165\u6a21\u677f\u4e0b\u8f7d\u5931\u8d25 %s", (Object[])new Object[]{taskCode});
        return localFile;
    }

    private ExcelFileVo convertExcelFileVo(File file) {
        ExcelFileVo vo = new ExcelFileVo();
        vo.setFileName(file.getName());
        vo.setParentPath(file.getParent());
        try {
            vo.setPath(file.getCanonicalPath());
        }
        catch (IOException e) {
            vo.setPath(file.getPath());
        }
        return vo;
    }

    private TaskGlobalParamsVo findParams(ImportTask task) {
        Validate.notNull((Object)((Object)task), (String)"\u5bfc\u5165\u4efb\u52a1\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        TaskGlobalParamsVo vo = new TaskGlobalParamsVo();
        vo.setAppCode(task.getAppCode());
        vo.setApplicationName(task.getApplicationName());
        vo.setCreateAccount(task.getCreateAccount());
        vo.setCreateAccountName(task.getCreateName());
        vo.setTaskCreateTime(task.getCreateTime());
        vo.setTenantCode(task.getTenantCode());
        vo.setTaskCode(task.getTaskCode());
        return vo;
    }

    private void handlerTaskFailed(String taskCode, String msg, String account) {
        ImportTaskUpdateModelVo vo = new ImportTaskUpdateModelVo();
        vo.setTaskCode(taskCode);
        vo.setExecStatus(ExecStatusEnum.FAILED.getDictCode());
        vo.setRemark(msg);
        this.importTaskThreadLocalServImpl.updateByImportTaskUpdateModelVo(vo);
        this.importSendProcessMsgBean.sendFailedProcessMsg(taskCode, msg, account);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callBack(String taskCode) {
        block21: {
            if (CollectionUtils.isEmpty(this.notifyEventListeners)) {
                return;
            }
            boolean locked = false;
            String lockKey = CharSequenceUtil.format((CharSequence)"bz:crm:ie:import:lock:{}", (Object[])new Object[]{taskCode});
            try {
                ImportTask importTask;
                locked = this.redisMutexService.tryLock(lockKey, TimeUnit.SECONDS, 5);
                if (!locked) break block21;
                long taskExecutionAfterSleep = this.importExportProperties.getTaskExecutionIntervalSleep();
                if (taskExecutionAfterSleep > 0L) {
                    ThreadUtil.sleep((long)taskExecutionAfterSleep);
                    log.debug("******\u4f11\u7720\u91ca\u653e\u6570\u636e\u5e93\u538b\u529b*********");
                }
                if (Objects.isNull((Object)(importTask = this.importTaskRepository.findByTaskCode(taskCode)))) {
                    log.warn("\u6267\u884c\u5931\u8d25\u56de\u8c03\u672a\u80fd\u627e\u5230\u5bf9\u5e94\u5bfc\u5165\u4efb\u52a1\u4fe1\u606f[{}]", (Object)taskCode);
                    return;
                }
                CallbackStatusEnum callbackStatusEnum = CallbackStatusEnum.getByDictCode((String)importTask.getCallBackStatus());
                if (Objects.nonNull(callbackStatusEnum)) {
                    log.warn("\u5bfc\u5165\u4efb\u52a1[{}],\u8df3\u8fc7\u672c\u6b21\u56de\u8c03\u6267\u884c\u64cd\u4f5c[{}]", (Object)callbackStatusEnum.getValue(), (Object)importTask.getExecStatus());
                    return;
                }
                ImportTaskEventVo importTaskEventVo = (ImportTaskEventVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)importTask, ImportTaskEventVo.class, HashSet.class, ArrayList.class, new String[0]);
                CallbackStatusEnum callbackStatus = null;
                try {
                    if (ExecStatusEnum.FAILED.getDictCode().equals(importTask.getExecStatus()) || !ImportDataStatusEnum.IMPORT_SUCCESS.getDictCode().equals(importTask.getImportDataStatus()) && !ImportDataStatusEnum.IMPORT_FAILED_SECTION.getDictCode().equals(importTask.getImportDataStatus())) {
                        log.info("\u5bfc\u5165\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}]\u6570\u636e\u5bfc\u5165\u72b6\u6001[{}],\u6267\u884c\u5931\u8d25\u56de\u8c03\u64cd\u4f5c", new Object[]{taskCode, importTask.getExecStatus(), importTask.getImportDataStatus()});
                        this.notifyEventListeners.forEach(eventListener -> eventListener.onFail(importTaskEventVo));
                        callbackStatus = CallbackStatusEnum.HAVE_CALL_BACK_FAIL;
                    } else if (ExecStatusEnum.FINISH.getDictCode().equals(importTask.getExecStatus()) && ImportDataStatusEnum.IMPORT_SUCCESS.getDictCode().equals(importTask.getImportDataStatus())) {
                        log.info("\u5bfc\u5165\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}]\u6570\u636e\u5bfc\u5165\u72b6\u6001[{}],\u6267\u884c\u6210\u529f\u56de\u8c03\u64cd\u4f5c", new Object[]{taskCode, importTask.getExecStatus(), importTask.getImportDataStatus()});
                        this.notifyEventListeners.forEach(eventListener -> eventListener.onSuccess(importTaskEventVo));
                        callbackStatus = CallbackStatusEnum.HAVE_CALL_BACK_SUCCESS;
                    } else if (ExecStatusEnum.FINISH.getDictCode().equals(importTask.getExecStatus()) && ImportDataStatusEnum.IMPORT_FAILED_SECTION.getDictCode().equals(importTask.getImportDataStatus())) {
                        log.info("\u5bfc\u5165\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}]\u6570\u636e\u5bfc\u5165\u72b6\u6001[{}],\u6267\u884c\u90e8\u5206\u6210\u529f\u56de\u8c03\u64cd\u4f5c", new Object[]{taskCode, importTask.getExecStatus(), importTask.getImportDataStatus()});
                        this.notifyEventListeners.forEach(eventListener -> eventListener.onPartialSuccess(importTaskEventVo));
                        callbackStatus = CallbackStatusEnum.HAVE_CALL_BACK_PARTIAL_SUCCESS;
                    } else {
                        log.info("\u5bfc\u5165\u4efb\u52a1[{}]\u5f53\u524d\u4efb\u52a1\u72b6\u6001[{}]\u6570\u636e\u5bfc\u5165\u72b6\u6001[{}],\u6ca1\u6709\u5339\u914d\u7684\u56de\u8c03\u64cd\u4f5c", new Object[]{taskCode, importTask.getExecStatus(), importTask.getImportDataStatus()});
                    }
                }
                catch (Exception e) {
                    log.error("\u5bfc\u5165\u4efb\u52a1\u6267\u884c\u56de\u8c03\u53d1\u751f\u5f02\u5e38", (Throwable)e);
                }
                if (Objects.nonNull(callbackStatus)) {
                    this.importTaskRepository.updateCallBackStatusByIds(Lists.newArrayList((Object[])new String[]{importTask.getId()}), callbackStatus);
                }
            }
            catch (Exception e) {
                log.error("\u5bfc\u5165\u4efb\u52a1\u6267\u884c\u56de\u8c03\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            }
            finally {
                if (locked) {
                    this.redisMutexService.unlock(lockKey);
                }
            }
        }
    }
}

