/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.ie.local.service.task;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.thread.ExecutorBuilder;
import cn.hutool.core.thread.RejectPolicy;
import cn.hutool.core.thread.ThreadFactoryBuilder;
import com.biz.crm.common.ie.local.concurrent.threadpool.priority.ThreadPoolExecutorPriorityBlocking;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportThreadPoolExecutor {
    private static final Logger log = LoggerFactory.getLogger(ImportExportThreadPoolExecutor.class);
    private Integer importTaskCount;
    private Integer importWorkQueueCount;
    @Deprecated
    private Integer exportTaskCount;
    private Integer largeExportTaskCount;
    private Integer largeExportWorkQueueCount;
    private Integer largeExportTaskDataNum;
    private Integer mediumExportTaskCount;
    private Integer mediumExportWorkQueueCount;
    private Integer mediumExportTaskDataNum;
    private Integer smallExportTaskCount;
    private Integer smallExportWorkQueueCount;
    private Integer exportGetTotalTaskCount;
    private Integer exportGetTotalWorkQueueCount;
    private Integer exportEsParagraphTaskCount;
    private Integer exportEsParagraphWorkQueueCount;
    private static final Map<String, ThreadPoolExecutor> IMPORT_THREAD_POOL_EXECUTOR_MAP = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutor> EXPORT_THREAD_POOL_EXECUTOR_MAP = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutorPriorityBlocking> LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutorPriorityBlocking> MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutorPriorityBlocking> SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutor> EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP = Maps.newHashMap();
    private static final Map<String, ThreadPoolExecutor> EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP = Maps.newHashMap();

    public ThreadPoolExecutor findImportThreadPoolExecutorByKey(String key) {
        this.createImportPoolByKey(key);
        return IMPORT_THREAD_POOL_EXECUTOR_MAP.get(key);
    }

    public Map<String, ThreadPoolExecutor> getImportThreadPoolExecutorMap() {
        return IMPORT_THREAD_POOL_EXECUTOR_MAP;
    }

    public ThreadPoolExecutor findExportThreadPoolExecutorByKey(String key) {
        this.createExportPoolByKey(key);
        return EXPORT_THREAD_POOL_EXECUTOR_MAP.get(key);
    }

    public ThreadPoolExecutorPriorityBlocking findLargeExportThreadPoolExecutorByKeyPriorityBlocking(String key) {
        this.createLargeExportPoolByKeyPriorityBlocking(key);
        return LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.get(key);
    }

    public ThreadPoolExecutorPriorityBlocking findMediumExportThreadPoolExecutorByKeyPriorityBlocking(String key) {
        this.createMediumExportPoolByKeyPriorityBlocking(key);
        return MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.get(key);
    }

    public ThreadPoolExecutorPriorityBlocking findSmallExportThreadPoolExecutorByKeyPriorityBlocking(String key) {
        this.createSmallExportPoolByKeyPriorityBlocking(key);
        return SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.get(key);
    }

    public Map<String, ThreadPoolExecutor> getExportThreadPoolExecutorMap() {
        return EXPORT_THREAD_POOL_EXECUTOR_MAP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createImportPoolByKey(String key) {
        if (IMPORT_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutor> map = IMPORT_THREAD_POOL_EXECUTOR_MAP;
        synchronized (map) {
            if (IMPORT_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
                return;
            }
            ThreadPoolExecutor threadPoolExecutor = ExecutorBuilder.create().setCorePoolSize(this.getImportTaskCount().intValue()).setMaxPoolSize(this.getImportTaskCount().intValue()).setWorkQueue(new LinkedBlockingQueue(this.getImportWorkQueueCount())).setThreadFactory(ThreadFactoryBuilder.create().setNamePrefix(CharSequenceUtil.format((CharSequence)"bz-import-task-{}-", (Object[])new Object[]{key})).build()).build();
            IMPORT_THREAD_POOL_EXECUTOR_MAP.put(key, threadPoolExecutor);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5bfc\u5165\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExportPoolByKey(String key) {
        if (EXPORT_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutor> map = EXPORT_THREAD_POOL_EXECUTOR_MAP;
        synchronized (map) {
            if (EXPORT_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-task-{}-{}-", (Object[])new Object[]{key});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutor poolExe = ExecutorBuilder.create().setCorePoolSize(this.getExportTaskCount().intValue()).setMaxPoolSize(this.getExportTaskCount().intValue()).setWorkQueue(new LinkedBlockingQueue(this.getExportTaskCount())).setThreadFactory(threadFactory).build();
            EXPORT_THREAD_POOL_EXECUTOR_MAP.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5bfc\u51fa\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLargeExportPoolByKeyPriorityBlocking(String key) {
        if (LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutorPriorityBlocking> map = LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING;
        synchronized (map) {
            if (LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-task-{}-{}-", (Object[])new Object[]{key, "large"});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutorPriorityBlocking poolExe = new ThreadPoolExecutorPriorityBlocking((int)this.largeExportTaskCount, (int)this.largeExportTaskCount, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(this.largeExportWorkQueueCount), threadFactory, RejectPolicy.BLOCK.getValue());
            LARGE_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5927\u91cf\u6570\u636e\u5bfc\u51fa\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMediumExportPoolByKeyPriorityBlocking(String key) {
        if (MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutorPriorityBlocking> map = MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING;
        synchronized (map) {
            if (MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-task-{}-{}-", (Object[])new Object[]{key, "medium"});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutorPriorityBlocking poolExe = new ThreadPoolExecutorPriorityBlocking((int)this.mediumExportTaskCount, (int)this.mediumExportTaskCount, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(this.mediumExportWorkQueueCount), threadFactory, RejectPolicy.BLOCK.getValue());
            MEDIUM_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u4e2d\u91cf\u6570\u636e\u5bfc\u51fa\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSmallExportPoolByKeyPriorityBlocking(String key) {
        if (SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutorPriorityBlocking> map = SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING;
        synchronized (map) {
            if (SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-task-{}-{}-", (Object[])new Object[]{key, "small"});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutorPriorityBlocking poolExe = new ThreadPoolExecutorPriorityBlocking((int)this.smallExportTaskCount, (int)this.smallExportTaskCount, 1L, TimeUnit.SECONDS, new PriorityBlockingQueue<Runnable>(this.smallExportWorkQueueCount), threadFactory, RejectPolicy.BLOCK.getValue());
            SMALL_EXPORT_THREAD_POOL_EXECUTOR_MAP_PRIORITY_BLOCKING.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5c0f\u91cf\u6570\u636e\u5bfc\u51fa\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    public ThreadPoolExecutor findExportGetTotalThreadPoolExecutorByKey(String key) {
        this.createExportGetTotalThreadPoolExecutorByKey(key);
        return EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExportGetTotalThreadPoolExecutorByKey(String key) {
        if (EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutor> map = EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP;
        synchronized (map) {
            if (EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-task-getTotal-{}-", (Object[])new Object[]{key});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutor poolExe = ExecutorBuilder.create().setCorePoolSize(this.getExportGetTotalTaskCount().intValue()).setMaxPoolSize(this.getExportGetTotalTaskCount().intValue()).setWorkQueue(new LinkedBlockingQueue(this.getExportGetTotalWorkQueueCount())).setThreadFactory(threadFactory).build();
            EXPORT_GET_TOTAL_THREAD_POOL_EXECUTOR_MAP.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5bfc\u51fa\u521b\u5efa\u5f02\u6b65\u83b7\u53d6\u603b\u6570\u4efb\u52a1\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    public ThreadPoolExecutor findExportEsParagraphThreadPoolExecutorByKey(String key) {
        this.createExportEsParagraphThreadPoolExecutorByKey(key);
        return EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createExportEsParagraphThreadPoolExecutorByKey(String key) {
        if (EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
            return;
        }
        Map<String, ThreadPoolExecutor> map = EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP;
        synchronized (map) {
            if (EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP.containsKey(key)) {
                return;
            }
            String threadGroupName = CharSequenceUtil.format((CharSequence)"bz-export-es-paragraph-{}-", (Object[])new Object[]{key});
            ThreadFactory threadFactory = ThreadFactoryBuilder.create().setNamePrefix(threadGroupName).build();
            ThreadPoolExecutor poolExe = ExecutorBuilder.create().setCorePoolSize(this.getExportEsParagraphTaskCount().intValue()).setMaxPoolSize(this.getExportEsParagraphTaskCount().intValue()).setWorkQueue(new LinkedBlockingQueue(this.getExportEsParagraphWorkQueueCount())).setThreadFactory(threadFactory).build();
            EXPORT_ES_PARAGRAPH_THREAD_POOL_EXECUTOR_MAP.put(key, poolExe);
            log.info("---\u5e94\u7528\u79df\u6237\u4fe1\u606f\u4e3a{}\u5bfc\u51fa\u521b\u5efaES\u5206\u6bb5\u4efb\u52a1\u7ebf\u7a0b\u6c60\u6784\u5efa\u6210\u529f---", (Object)key);
        }
    }

    public Integer getImportTaskCount() {
        return this.importTaskCount;
    }

    public void setImportTaskCount(Integer importTaskCount) {
        this.importTaskCount = importTaskCount;
    }

    public Integer getImportWorkQueueCount() {
        return this.importWorkQueueCount;
    }

    public void setImportWorkQueueCount(Integer importWorkQueueCount) {
        this.importWorkQueueCount = importWorkQueueCount;
    }

    @Deprecated
    public Integer getExportTaskCount() {
        return this.exportTaskCount;
    }

    @Deprecated
    public void setExportTaskCount(Integer exportTaskCount) {
        this.exportTaskCount = exportTaskCount;
    }

    public Integer getLargeExportTaskCount() {
        return this.largeExportTaskCount;
    }

    public void setLargeExportTaskCount(Integer largeExportTaskCount) {
        this.largeExportTaskCount = largeExportTaskCount;
    }

    public Integer getLargeExportWorkQueueCount() {
        return this.largeExportWorkQueueCount;
    }

    public void setLargeExportWorkQueueCount(Integer largeExportWorkQueueCount) {
        this.largeExportWorkQueueCount = largeExportWorkQueueCount;
    }

    public Integer getLargeExportTaskDataNum() {
        return this.largeExportTaskDataNum;
    }

    public void setLargeExportTaskDataNum(Integer largeExportTaskDataNum) {
        this.largeExportTaskDataNum = largeExportTaskDataNum;
    }

    public Integer getMediumExportTaskCount() {
        return this.mediumExportTaskCount;
    }

    public void setMediumExportTaskCount(Integer mediumExportTaskCount) {
        this.mediumExportTaskCount = mediumExportTaskCount;
    }

    public Integer getMediumExportWorkQueueCount() {
        return this.mediumExportWorkQueueCount;
    }

    public void setMediumExportWorkQueueCount(Integer mediumExportWorkQueueCount) {
        this.mediumExportWorkQueueCount = mediumExportWorkQueueCount;
    }

    public Integer getMediumExportTaskDataNum() {
        return this.mediumExportTaskDataNum;
    }

    public void setMediumExportTaskDataNum(Integer mediumExportTaskDataNum) {
        this.mediumExportTaskDataNum = mediumExportTaskDataNum;
    }

    public Integer getSmallExportTaskCount() {
        return this.smallExportTaskCount;
    }

    public void setSmallExportTaskCount(Integer smallExportTaskCount) {
        this.smallExportTaskCount = smallExportTaskCount;
    }

    public Integer getSmallExportWorkQueueCount() {
        return this.smallExportWorkQueueCount;
    }

    public void setSmallExportWorkQueueCount(Integer smallExportWorkQueueCount) {
        this.smallExportWorkQueueCount = smallExportWorkQueueCount;
    }

    public Integer getExportGetTotalTaskCount() {
        return this.exportGetTotalTaskCount;
    }

    public void setExportGetTotalTaskCount(Integer exportGetTotalTaskCount) {
        this.exportGetTotalTaskCount = exportGetTotalTaskCount;
    }

    public Integer getExportGetTotalWorkQueueCount() {
        return this.exportGetTotalWorkQueueCount;
    }

    public void setExportGetTotalWorkQueueCount(Integer exportGetTotalWorkQueueCount) {
        this.exportGetTotalWorkQueueCount = exportGetTotalWorkQueueCount;
    }

    public Integer getExportEsParagraphTaskCount() {
        return this.exportEsParagraphTaskCount;
    }

    public void setExportEsParagraphTaskCount(Integer exportEsParagraphTaskCount) {
        this.exportEsParagraphTaskCount = exportEsParagraphTaskCount;
    }

    public Integer getExportEsParagraphWorkQueueCount() {
        return this.exportEsParagraphWorkQueueCount;
    }

    public void setExportEsParagraphWorkQueueCount(Integer exportEsParagraphWorkQueueCount) {
        this.exportEsParagraphWorkQueueCount = exportEsParagraphWorkQueueCount;
    }
}

