package com.biz.crm.common.ie.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.ie.local.entity.ImportTemplate;
import com.biz.crm.common.ie.sdk.dto.ImportTemplatePaginationDto;
import org.apache.ibatis.annotations.Param;

/**
 * 导入模板主表(ImportTemplate)表数据库访问层
 *
 * @author sunx
 * @date 2022-05-10 10:27:58
 */
public interface ImportTemplateMapper extends BaseMapper<ImportTemplate> {

  /**
   * 分页列表
   *
   * @param page 分页信息
   * @param dto 分页参数dto
   * @return 分页列表
   */
  Page<ImportTemplate> findByConditions(
      Page<ImportTemplate> page, @Param("dto") ImportTemplatePaginationDto dto);
}
